#!ruby -Ks

require "phi"
require "rdb"
require "RGUI"
require "cct30"
require "cct32"
include Phi

        ##
        ##  `[̈ꗗ\̃tH[
        ##
        ##  ObhőIƊ̓`[
        ##  `[tH[(cct32)JB
        ##
class FormDenGrid < RGUI::Form
 attr :dataset , true
end
form = FormDenGrid.new :form_den_grid , "`[Xg"

grid_den = DBGrid.new form , :grid_den
grid_den.align = Phi::AL_CLIENT

        ##
        ##  data access
        ##
form.dataset = DB.query <<EOT
  SELECT den_date, kokyaku_mei, gokei, M.den_id AS den_id
  FROM ap01den_mei M, ap01den_gokei G
  WHERE M.den_id = G.den_id
EOT
dataset = form.dataset
dataset.open

data_source = DataSource.new dataset
grid_den.data_source = data_source
grid_den.read_only = true

        ##
        ##  炩̓`[ύXɂȂ|̒ʒm󂯂́B
        ##
def form.refresh
  dataset.close
  dataset.open
  dataset['den_date']   .display_label = "`[t"
  dataset['kokyaku_mei'].display_label = "ڋq"
  dataset['gokei']      .display_label = "vz"
  dataset['den_id']     .visible = false
end

        ##
        ##  menu
        ##
Phi.new_menu form, :menu, [
      Phi.new_item( '&File' , '' , :mi_file ).add(
        Phi.new_item( 'e&xit' , 'Ctrl+Y', :mi_exit )
      ),
      Phi.new_item( '`[(&D)' , '' , :mi_den ).add(
        Phi.new_item( 'VK(&N)', 'Ctrl+N' , :mi_den_new ),
        Phi.new_item( '(&K)', 'Ctrl+K' , :mi_den_kensaku ),
        Phi.new_item( 'ҏW(&E)', 'Ctrl+E' , :mi_den_edit ),
        Phi.new_item( '(&D)', 'Ctrl+D' , :mi_den_dup ),
        Phi.new_item( 'p(&H)', 'Ctrl+H' , :mi_den_haiki )
      )
]
form.menu_attr_flatten

        ##
        ##  event handlers
        ##
form.mi_exit.on_click           = proc { exit }
form.mi_den_new.on_click        = proc {}
form.mi_den_kensaku.on_click    = proc {}

        ##
        ##  event handler of den_selected
        ##  for     ret on grid
        ##      and dbl_click on grid
        ##
        ##  set den_id on form_den_edit
        ##  which do many job. see cct32.rb.
        ##
den_selected = proc {
  id    = dataset['den_id'].to_i
  f     = Phi::SCREEN.form_den_edit
  f.den_id = id     ##  cct32.rb[def form.den_id=]
  f.show
  f.set_focus
}
grid_den.on_dbl_click     = den_selected
form.mi_den_edit.on_click = den_selected

grid_den.on_key_press = proc{ |sender,key|
  case key
  when 13       #   "\n"
    den_selected.call
  end
}

form.mi_den_haiki.on_click = proc {
  id = dataset['den_id'].to_i
  f = Phi::SCREEN.form_den_edit
  f.den_id = id     ##  cct32.rb[def form.den_id=]
  f.show
  f.set_focus
  f.den_haiki
}

        ##
        ##  main
        ##
form.refresh
form.show

if __FILE__ == $0
  Phi.mainloop
end
