unit DialogsHandle;

interface

uses
  Windows, Classes, Rubies;

type
  TDialogsHandle = class(TObject)
  published
    { TFindDialog }
    procedure NotifyOnFind(Sender: TObject);
    { TReplaceDialog }
    procedure NotifyOnReplace(Sender: TObject);
    { TOpenDialog }
    procedure NotifyOnFolderChange(Sender: TObject);
    procedure NotifyOnSelectionChange(Sender: TObject);
    procedure NotifyOnTypeChange(Sender: TObject);
    procedure CloseQueryOnCanClose(Sender: TObject; var CanClose: Boolean);
  end;

var
  Handle: TDialogsHandle;

implementation

uses Pythia;

{ TFindDialog }

procedure TDialogsHandle.NotifyOnFind(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_find');
end;

{ TReplaceDialog }

procedure TDialogsHandle.NotifyOnReplace(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_replace');
end;

{ TOpenDialog }

procedure TDialogsHandle.NotifyOnFolderChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_folder_change');
end;

procedure TDialogsHandle.NotifyOnSelectionChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_selection_change');
end;

procedure TDialogsHandle.NotifyOnTypeChange(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_type_change');
end;

//OnCanClose CxǵC[U[CLZɃ_CAO{bNX悤ƂƂɔ܂B
//type TCloseQueryEvent = procedure(Sender: TObject; var CanClose: Boolean) of object;
//property OnCanClose: TCloseQueryEvent;
// cf. C:/PROGRA~1/Apollo/src/PhiHandle.pas[CloseQueryOnCloseQuery]

procedure TDialogsHandle.CloseQueryOnCanClose(Sender: TObject; var CanClose: Boolean);
var
  recv, data, ret: Tvalue;
begin
//rb_p(ap_String('enter'));
  recv := (Sender as TComponent).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_can_close'));
  rb_ary_push(data, recv);
  rb_ary_push(data, ap_bool(CanClose));
  ret := PhiCallProtect(data);
  if ret <> Qnil then CanClose := RTEST(ret);
end;

initialization
  Handle := TDialogsHandle.Create;
finalization
  Handle.Free;
end.
