unit uEditor;

interface

uses
  Rubies, EditorHandle, HEditor, Menus;

var
  Handle: TEditorHandle;
  cEditor: Tvalue;

procedure Init_Editor_module;
function ap_cEditor: Tvalue;
function EditorGetHandle: TEditorHandle;
procedure Editor_setup(obj: Tvalue; real: TEditor);
function ap_iEditor(real: TEditor; owner: Tvalue): Tvalue;

implementation

uses
  Windows, SysUtils, Classes, Controls,
  Pythia, uStrUtils, uDefUtils,
  heClasses, heUtils, HViewEdt, heRaStrings,
  uNotifyPersistent,
  uEditorStrings, uEditorViewInfo, uEditorMark, uEditorCursor,
  uEditorCaret, uEditorMargin, uEditorLeftbar, uEditorRuler,
  uEditorToken, uEditorWrapOption,
  uFountain, uFountainParser, uEditorFountain;

type
  TPhiEditor = class(TEditor);

function ap_cEditor: Tvalue;
begin
  result := cEditor;
end;

function EditorGetHandle: TEditorHandle;
begin
  result := Handle;
end;

procedure Editor_setup(obj: Tvalue; real: TEditor);
begin
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@lines', ap_iStrings(real.Lines, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@margin', ap_iEditorMargin(real.Margin, obj));
  rb_iv_set(obj, '@view', ap_iEditorViewInfo(real.View, obj));
  rb_iv_set(obj, '@reserve_word_list', ap_iStrings(real.ReserveWordList, obj));
  rb_iv_set(obj, '@caret', ap_iEditorCaret(real.Caret, obj));
  rb_iv_set(obj, '@marks', ap_iEditorMarks(real.Marks, obj));
  rb_iv_set(obj, '@leftbar', ap_iEditorLeftbar(real.Leftbar, obj));
  rb_iv_set(obj, '@ruler', ap_iEditorRuler(real.Ruler, obj));
  rb_iv_set(obj, '@wrap_option', ap_iEditorWrapOption(real.WrapOption, obj));
//  rb_iv_set(obj, '@fountain', ap_iFountain(real.Fountain, obj));
  rb_iv_set(obj, '@popup_menu', ap_iPopupMenu(real.PopupMenu, obj));
end;

function Editor_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function Editor_alloc(klass: Tvalue; real: TEditor): Tvalue;
begin
  result := ChildAlloc(klass, real);
  Editor_setup(result, real);
end;

function ap_iEditor(real: TEditor; owner: Tvalue): Tvalue;
begin
  result := Editor_alloc(cEditor, real);
  ap_owner(result, owner);
end;

function ap_iEditor_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditor(TEditor(AControl), owner)
end;

function Editor_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := TEditor.Create(nil);
  result := CompoAlloc(This, real);
  Editor_setup(result, real);
end;

function Editor_get_url_chars(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(CharSetToStr(UrlChars));
end;

function Editor_set_url_chars(This,v: Tvalue): Tvalue; cdecl;
begin
  result := This;
  UrlChars := StrToCharSet(dl_String(v));
end;

function Editor_can_redo(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.CanRedo);
end;

function Editor_can_undo(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.CanUndo);
end;

function Editor_list_string(This, index: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(index);
  result := This;
  try
    result := rb_str_new2(PChar(real.ListString[n]));
  except
    ap_raise(ap_eArgError, sOut_of_range);
  end;
end;

function Editor_left_margin(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.LeftMargin);
end;

function Editor_draw_text_rect(This, rect, x, y, str, opt: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := This;
  real.DrawTextRect(PRect(ap_data_get_struct(rect))^, FIX2INT(x), FIX2INT(y), dl_String(str), FIX2INT(opt));
end;

function Editor_word_from_caret(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.WordFromCaret));
end;

function Editor_word_from_pos(This, point: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.WordFromPos(PPoint(ap_data_get_struct(point))^)));
end;

function Editor_token_from_caret(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  ch: Char;
begin
  real := ap_data_get_struct(This);
  ch := real.TokenFromCaret;
  result := CHR2FIX(ch);
end;

function Editor_token_from_pos(This, point: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  ch: Char;
begin
  real := ap_data_get_struct(This);
  ch := real.TokenFromPos(PPoint(ap_data_get_struct(point))^);
  result := CHR2FIX(ch);
end;

function Editor_token_string_from_caret(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.TokenStringFromCaret));
end;

function Editor_token_string_from_pos(This, point: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.TokenStringFromPos(PPoint(ap_data_get_struct(point))^)));
end;

function Editor_pos_to_row_col(This, x, y, split: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  row, col: Integer;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  real.PosToRowCol(FIX2INT(x), FIX2INT(y), row, col, RTEST(split));
  rb_ary_push(result, INT2FIX(row));
  rb_ary_push(result, INT2FIX(col));
end;

function Editor_can_sel_drag(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.CanSelDrag);
end;

function Editor_is_selected_area(This, row, col: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.IsSelectedArea(FIX2INT(row), FIX2INT(col)));
end;

function Editor_clean_selection(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.CleanSelection;
  result := This;
end;

function Editor_clear_selection(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.ClearSelection;
  result := This;
end;

function Editor_copy_selection(This, row, col: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.CopySelection(FIX2INT(row), FIX2INT(col));
  result := This;
end;

function Editor_move_selection(This, row, col: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.MoveSelection(FIX2INT(row), FIX2INT(col));
  result := This;
end;

function Editor_copy_to_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.CopyToClipboard;
  result := This;
end;

function Editor_cut_to_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.CutToClipboard;
  result := This;
end;

function Editor_paste_from_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.PasteFromClipboard;
  result := This;
end;

function Editor_select_all(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelectAll;
  result := This;
end;

function Editor_undo(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.Undo;
  result := This;
end;

function Editor_redo(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.Redo;
  result := This;
end;

function Editor_set_row_col(This, row, col: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SetRowCol(FIX2INT(row), FIX2INT(col));
  result := This;
end;

function Editor_get_col_width(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ColWidth);
end;

function Editor_get_row_height(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.RowHeight);
end;

function Editor_get_top_margin(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TopMargin);
end;

function Editor_get_left_scroll_width(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.LeftScrollWidth);
end;

function Editor_get_cursor_state(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.CursorState));
end;

function Editor_get_row(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Row);
end;

function Editor_set_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.Row := FIX2INT(v);
end;

function Editor_get_col(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Col);
end;

function Editor_set_col(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.col := FIX2INT(v);
end;

function Editor_get_list_count(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ListCount);
end;

function Editor_get_col_count(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ColCount);
end;

function Editor_get_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.RowCount);
end;

function Editor_get_font_height(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.FontHeight);
end;

function Editor_get_modified(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Modified);
end;

function Editor_set_modified(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.Modified := RTEST(v);
  result := v;
end;

function Editor_get_over_write(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.OverWrite);
end;

function Editor_set_over_write(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.OverWrite := RTEST(v);
end;

function Editor_get_selection_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.SelectionMode));
end;

function Editor_set_selection_mode(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelectionMode := TEditorSelectionMode(dl_Integer(v));
  result := v;
end;

function Editor_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Selected);
end;

function Editor_get_sel_length(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.SelLength);
end;

function Editor_set_sel_length(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.SelLength := FIX2INT(v);
end;

function Editor_get_sel_start(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.SelStart);
end;

function Editor_set_sel_start(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.SelStart := FIX2INT(v);
end;

function Editor_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

function Editor_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := v;
  real.SelText := dl_String(v);
end;

function Editor_get_top_col(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TopCol);
end;

function Editor_set_top_col(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.TopCol := dl_Integer(v);
  result := v;
end;

function Editor_get_top_row(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TopRow);
end;

function Editor_set_top_row(This,v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.TopRow := dl_Integer(v);
  result := v;
end;

function Editor_set_undo_list_max(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.UndoListMax := FIX2INT(v);
  result := v;
end;

function Editor_get_undo_list_max(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.UndoListMax);
end;

function Editor_expand_tab(This,v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.ExpandTab(dl_String(v)));
end;

function Editor_row_to_lines(This,v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RowToLines(dl_Integer(v)));
end;

function Editor_lines_to_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.LinesToRow(dl_Integer(v)));
end;

function Editor_col_to_char(This, row,col: Tvalue): Tvalue; cdecl;
var
  real:TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ColToChar(dl_Integer(row),dl_Integer(col)));
end;

function Editor_find_next_word_start(This, r, c, d: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
  Row, Col, Direction: integer;
begin
  real := ap_data_get_struct(This);
  Row := dl_Integer(r);
  Col := dl_Integer(c);
  Direction := dl_Integer(d);
  if real.FindNextWordStart(Row, Col, Direction) then
  begin
    real.SetRowCol(Row, Col);
    result := Qtrue;
  end else begin
    result := Qfalse;
  end;
end;

function Editor_str_to_attributes(This,v: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.StrToAttributes(dl_String(v)));
end;

function Editor_sel_str_position(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  position: TSelectedPosition;
begin
  real := ap_data_get_struct(This);
  position := real.SelStrPosition;
  result := rb_ary_new;
  rb_ary_push(result, INT2FIX(position.sr));
  rb_ary_push(result, INT2FIX(position.sc));
  rb_ary_push(result, INT2FIX(position.er));
  rb_ary_push(result, INT2FIX(position.ec));
end;

function Editor_edit_editor(This, opt: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
  option: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(opt, TPersistent, option);
  result := ap_Bool(EditEditor(real, option));
end;

function Editor_exchange_list(This, src: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
  Source: TEditor;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(src, TEditor, Source);
  real.ExchangeList(Source);
  result := This;
end;

function Editor_put_row_mark(This, Index, Mark: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.PutRowMark( dl_Integer(Index), TRowMark(dl_Integer(Mark)));
  result := This;
end;

function Editor_delete_row_mark(This, Index, Mark: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.DeleteRowMark( dl_Integer(Index), TRowMark(dl_Integer(Mark)));
  result := This;
end;

function Editor_goto_row_mark(This, Mark: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.GotoRowMark( TRowMark(dl_Integer(Mark)));
  result := This;
end;

function Editor_start_row_selection(This, Row: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.StartRowSelection(dl_Integer(Row));
  result := This;
end;

function Editor_update_row_selection(This, Row: Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.UpdateRowSelection(dl_Integer(Row));
  result := This;
end;

function Editor_set_popup_menu(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  PopupMenu: TEditorPopupMenu;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPopupMenu, PopupMenu);
  real.PopupMenu := PopupMenu;
  result := v;
end;

(**** str2 made by ap_src_maker ****)

function Editor_cancel_sel_drag(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.CancelSelDrag;
  result := This;
end;

function Editor_char_from_pos(This, Pos : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Pos : TPoint;
begin
  real := ap_data_get_struct(This);
  dl_Pos := dl_Point(Pos);
  result := ap_Integer(real.CharFromPos( dl_Pos ));
end;

function Editor_clear(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function Editor_delete_row(This, Index : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(Index);
  real.DeleteRow( dl_Index );
  result := This;
end;

function Editor_expand_tab_length(This, S : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_S : String;
begin
  real := ap_data_get_struct(This);
  dl_S := dl_String(S);
  result := ap_Integer(real.ExpandTabLength( dl_S ));
end;

function Editor_get_sel_text_buf(This, Buffer, BufSize : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Buffer : PChar;
  dl_BufSize : Integer;
begin
  real := ap_data_get_struct(This);
  dl_Buffer := ap_data_get_struct(Buffer);
  dl_BufSize := dl_Integer(BufSize);
  result := ap_Integer(real.GetSelTextBuf( dl_Buffer, dl_BufSize ));
end;

function Editor_get_text_len(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.GetTextLen);
end;

function Editor_hit_to_selected(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.HitToSelected;
  result := This;
end;

function Editor_list_to_file(This, FileName : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_FileName : String;
begin
  real := ap_data_get_struct(This);
  dl_FileName := dl_String(FileName);
  real.ListToFile( dl_FileName );
  result := This;
end;

function Editor_list_to_stream(This, Stream : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Stream : TStream;
begin
  real := ap_data_get_struct(This);
  dl_Stream := ap_data_get_struct(Stream);
  real.ListToStream( dl_Stream );
  result := This;
end;

function Editor_select_token_bracket_from_caret(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelectTokenBracketFromCaret;
  result := This;
end;

function Editor_select_token_from_caret(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelectTokenFromCaret;
  result := This;
end;

function Editor_select_word_from_caret(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelectWordFromCaret;
  result := This;
end;

function Editor_sel_indent(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelIndent;
  result := This;
end;

function Editor_sel_un_indent(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelUnIndent;
  result := This;
end;

function Editor_sel_tab_indent(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelTabIndent;
  result := This;
end;

function Editor_sel_tab_un_indent(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.SelTabUnIndent;
  result := This;
end;

function Editor_set_sel_text_box(This, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Buffer : PChar;
begin
  real := ap_data_get_struct(This);
  dl_Buffer := ap_data_get_struct(Buffer);
  real.SetSelTextBox( dl_Buffer );
  result := This;
end;

function Editor_set_sel_text_buf(This, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Buffer : PChar;
begin
  real := ap_data_get_struct(This);
  dl_Buffer := ap_data_get_struct(Buffer);
  real.SetSelTextBuf( dl_Buffer );
  result := This;
end;

function Editor_token_string_bracket_from_caret(This : Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.TokenStringBracketFromCaret);
end;

function Editor_get_active_fountain(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_iFountain(real.ActiveFountain,This);
end;

function Editor_get_hit_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.HitSelected);
end;

function Editor_get_hit_sel_length(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.HitSelLength);
end;

function Editor_set_hit_sel_length(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  real.HitSelLength := dl_Integer(v);
  result := v;
end;

function Editor_get_list_bracket(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.ListBracket[dl_Index]);
end;

function Editor_get_list_data_string(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_String(real.ListDataString[dl_Index]);
end;

function Editor_get_list_element(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.ListElement[dl_Index]);
end;

function Editor_get_list_remain(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.ListRemain[dl_Index]);
end;

function Editor_get_list_wrapped_byte(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.ListWrappedByte[dl_Index]);
end;

function Editor_get_selected_data(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.SelectedData);
end;

function Editor_get_selected_draw(This: Tvalue): Tvalue; cdecl;
var
  real: TEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.SelectedDraw);
end;
(**** made by ap_src_maker ****)

function Editor_set_ime_composition(This : Tvalue): Tvalue; cdecl;
var
  real: TPhiEditor;
begin
  real := ap_data_get_struct(This);
  real.SetImeComposition;
  result := This;
end;

procedure Init_Editor_module;
begin
  cEditor := DefinePersistentClass(ap_mPhi, TEditor, ap_cWinControl, ap_iEditor_v);

  DefineConstSetType(cEditor, TypeInfo(TEditorSelectionState));
  DefineConstSetType(cEditor, TypeInfo(TEditorSelectionMode));
  DefineConstSetType(cEditor, TypeInfo(TEditorSelDragState));
  DefineConstSetType(cEditor, TypeInfo(TEditorMouseCursorState));

  Init_NotifyPersistent;
  Init_EditorStrings;
  Init_Fountain;
  Init_FountainParser;
  Init_EditorFountain;
  Init_EditorViewInfo;
  Init_EditorMark;
  Init_EditorCursor;
  Init_EditorCaret;
  Init_EditorMargin;
  Init_EditorLeftbar;
  Init_EditorRuler;
  Init_EditorToken;
  Init_EditorWrapOption;

  rb_define_method(cEditor, 'event_handle', @Editor_event_handle, 1);
  rb_define_alloc_func(cEditor, @Editor_allocate);
  rb_define_singleton_method(cEditor, 'url_chars', @Editor_get_url_chars, 0);
  rb_define_singleton_method(cEditor, 'url_chars=', @Editor_set_url_chars, 1);

  rb_define_method(cEditor, 'can_redo', @Editor_can_redo, 0);
  rb_define_method(cEditor, 'can_undo', @Editor_can_undo, 0);
  rb_define_method(cEditor, 'list_string', @Editor_list_string, 1);
  rb_define_method(cEditor, 'left_margin', @Editor_left_margin, 0);
  rb_define_method(cEditor, 'draw_text_rect', @Editor_draw_text_rect, 5);
  rb_define_method(cEditor, 'word_from_caret', @Editor_word_from_caret, 0);
  rb_define_method(cEditor, 'word_from_pos', @Editor_word_from_pos, 1);
  rb_define_method(cEditor, 'token_from_caret', @Editor_token_from_caret, 0);
  rb_define_method(cEditor, 'token_from_pos', @Editor_token_from_pos, 1);
  rb_define_method(cEditor, 'token_string_from_caret', @Editor_token_string_from_caret, 0);
  rb_define_method(cEditor, 'token_string_from_pos', @Editor_token_string_from_pos, 1);
  rb_define_method(cEditor, 'pos_to_row_col', @Editor_pos_to_row_col, 3);
  rb_define_method(cEditor, 'can_sel_drag?', @Editor_can_sel_drag, 0);
  rb_define_method(cEditor, 'selected_area?', @Editor_is_selected_area, 2);
  rb_define_method(cEditor, 'clean_selection', @Editor_clean_selection, 0);
  rb_define_method(cEditor, 'clear_selection', @Editor_clear_selection, 0);
  rb_define_method(cEditor, 'copy_selection', @Editor_copy_selection, 2);
  rb_define_method(cEditor, 'move_selection', @Editor_move_selection, 2);
  rb_define_method(cEditor, 'set_row_col', @Editor_set_row_col, 2);
  rb_define_method(cEditor, 'copy_to_clipboard', @Editor_copy_to_clipboard, 0);
  rb_define_method(cEditor, 'cut_to_clipboard', @Editor_cut_to_clipboard, 0);
  rb_define_method(cEditor, 'paste_from_clipboard', @Editor_paste_from_clipboard, 0);
  rb_define_method(cEditor, 'select_all', @Editor_select_all, 0);
  rb_define_method(cEditor, 'undo', @Editor_undo, 0);
  rb_define_method(cEditor, 'redo', @Editor_redo, 0);

  // public properties
  DefineAttrGet(cEditor, 'col', Editor_get_col);
  DefineAttrSet(cEditor, 'col', Editor_set_col);
  DefineAttrGet(cEditor, 'col_count', Editor_get_col_count);
  DefineAttrGet(cEditor, 'col_width', Editor_get_col_width);
  DefineAttrGet(cEditor, 'cursor_state', Editor_get_cursor_state);
  DefineAttrGet(cEditor, 'font_height', Editor_get_font_height);
  DefineAttrGet(cEditor, 'left_scroll_width', Editor_get_left_scroll_width);
  DefineAttrGet(cEditor, 'list_count', Editor_get_list_count);
  DefineAttrGet(cEditor, 'modified', Editor_get_modified);
  DefineAttrSet(cEditor, 'modified', Editor_set_modified);
  DefineAttrGet(cEditor, 'over_write', Editor_get_over_write);
  DefineAttrSet(cEditor, 'over_write', Editor_set_over_write);
  DefineAttrGet(cEditor, 'row', Editor_get_row);
  DefineAttrSet(cEditor, 'row', Editor_set_row);
  DefineAttrGet(cEditor, 'row_count', Editor_get_row_count);
  DefineAttrGet(cEditor, 'row_height', Editor_get_row_height);
    // not yet: sel_draw_position
  DefineAttrGet(cEditor, 'selection_mode', Editor_get_selection_mode);
  DefineAttrSet(cEditor, 'selection_mode', Editor_set_selection_mode);
  DefineAttrGet(cEditor, 'selected', Editor_get_selected);
  DefineAttrGet(cEditor, 'sel_length', Editor_get_sel_length);
  DefineAttrSet(cEditor, 'sel_length', Editor_set_sel_length);
  DefineAttrGet(cEditor, 'sel_start', Editor_get_sel_start);
  DefineAttrSet(cEditor, 'sel_start', Editor_set_sel_start);
    // not yet: sel_str_position
  DefineAttrGet(cEditor, 'sel_text', Editor_get_sel_text);
  DefineAttrSet(cEditor, 'sel_text', Editor_set_sel_text);
  DefineAttrGet(cEditor, 'top_col', Editor_get_top_col);
  DefineAttrSet(cEditor, 'top_col', Editor_set_top_col);
  DefineAttrGet(cEditor, 'top_row', Editor_get_top_row);
  DefineAttrSet(cEditor, 'top_row', Editor_set_top_row);
  DefineAttrGet(cEditor, 'top_margin', Editor_get_top_margin);
  DefineAttrSet(cEditor, 'undo_list_max', Editor_set_undo_list_max);
  DefineAttrGet(cEditor, 'undo_list_max', Editor_get_undo_list_max);
  rb_define_method(cEditor, 'expand_tab', @Editor_expand_tab, 1);
  rb_define_method(cEditor, 'row_to_lines', @Editor_row_to_lines, 1);
  rb_define_method(cEditor, 'lines_to_row', @Editor_lines_to_row, 1);
  rb_define_method(cEditor, 'col_to_char', @Editor_col_to_char, 2);

  rb_define_method(cEditor, 'str_to_attributes', @Editor_str_to_attributes, 1);
  rb_define_method(cEditor, 'sel_str_position', @Editor_sel_str_position, 0);
  rb_define_method(cEditor, 'edit_editor', @Editor_edit_editor, 1);
  rb_define_method(cEditor, 'exchange_list', @Editor_exchange_list, 1);
  rb_define_method(cEditor, 'put_row_mark', @Editor_put_row_mark, 2);
  rb_define_method(cEditor, 'delete_row_mark', @Editor_delete_row_mark, 2);
  rb_define_method(cEditor, 'goto_row_mark', @Editor_goto_row_mark, 1);
  rb_define_method(cEditor, 'start_row_selection', @Editor_start_row_selection, 1);
  rb_define_method(cEditor, 'update_row_selection', @Editor_update_row_selection, 1);
  DefineAttrSet(cEditor, 'popup_menu', Editor_set_popup_menu);

  rb_define_attr(cEditor, 'canvas', 1, 0);

(**** str3 made by ap_src_maker ****)
  // get_xx set_xx ̓_ủ\̂ŁA_܂ŃRgAEgB
  rb_define_method(cEditor, 'cancel_sel_drag', @Editor_cancel_sel_drag, 0);
  rb_define_method(cEditor, 'clear', @Editor_clear, 0);
  rb_define_method(cEditor, 'delete_row', @Editor_delete_row, 1);
  rb_define_method(cEditor, 'expand_tab_length', @Editor_expand_tab_length, 1);
  //rb_define_method(cEditor, 'get_sel_text_buf', @Editor_get_sel_text_buf, 2);
  //rb_define_method(cEditor, 'get_text_len', @Editor_get_text_len, 0);
  rb_define_method(cEditor, 'hit_to_selected', @Editor_hit_to_selected, 0);
  rb_define_method(cEditor, 'list_to_file', @Editor_list_to_file, 1);
  rb_define_method(cEditor, 'list_to_stream', @Editor_list_to_stream, 1);
  rb_define_method(cEditor, 'select_token_bracket_from_caret', @Editor_select_token_bracket_from_caret, 0);
  rb_define_method(cEditor, 'select_token_from_caret', @Editor_select_token_from_caret, 0);
  rb_define_method(cEditor, 'select_word_from_caret', @Editor_select_word_from_caret, 0);
  rb_define_method(cEditor, 'sel_indent', @Editor_sel_indent, 0);
  rb_define_method(cEditor, 'sel_un_indent', @Editor_sel_un_indent, 0);
  rb_define_method(cEditor, 'sel_tab_indent', @Editor_sel_tab_indent, 0);
  rb_define_method(cEditor, 'sel_tab_un_indent', @Editor_sel_tab_un_indent, 0);
  //rb_define_method(cEditor, 'set_sel_text_box', @Editor_set_sel_text_box, 1);
  //rb_define_method(cEditor, 'set_sel_text_buf', @Editor_set_sel_text_buf, 1);
  rb_define_method(cEditor, 'token_string_bracket_from_caret', @Editor_token_string_bracket_from_caret, 0);
  DefineAttrGet(cEditor, 'active_fountain', Editor_get_active_fountain);
  DefineAttrGet(cEditor, 'hit_selected', Editor_get_hit_selected);
  DefineAttrGet(cEditor, 'hit_selected?', Editor_get_hit_selected);
  DefineAttrGet(cEditor, 'hit_sel_length', Editor_get_hit_sel_length);
  DefineAttrSet(cEditor, 'hit_sel_length', Editor_set_hit_sel_length);
  DefineIndexer(cEditor, 'list_bracket', @Editor_get_list_bracket, nil);
  DefineIndexer(cEditor, 'list_data_string', @Editor_get_list_data_string, nil);
  DefineIndexer(cEditor, 'list_element', @Editor_get_list_element, nil);
  DefineIndexer(cEditor, 'list_remain', @Editor_get_list_remain, nil);
  DefineIndexer(cEditor, 'list_wrapped_byte', @Editor_get_list_wrapped_byte, nil);
  DefineAttrGet(cEditor, 'selected_data', Editor_get_selected_data);
  DefineAttrGet(cEditor, 'selected_data?', Editor_get_selected_data);
  DefineAttrGet(cEditor, 'selected_draw', Editor_get_selected_draw);
  DefineAttrGet(cEditor, 'selected_draw?', Editor_get_selected_draw);
(**** made by ap_src_maker ****)

  rb_define_method(cEditor, 'set_ime_composition', @Editor_set_ime_composition, 0);

end;

initialization
  Handle := TEditorHandle.Create;
finalization
  Handle.Free;
end.
