unit uRubyFountain;

interface

uses
  Rubies, RubyFountain;

var
  cRubyFountain: Tvalue;

function ap_iRubyFountain(real: TRubyFountain; owner: Tvalue): Tvalue;
procedure Init_RubyFountain;

implementation

uses
  Pythia, heFountain, uEditor, uFountain, uFountainColor;

procedure RubyFountain_setup(obj: Tvalue; real: TRubyFountain);
begin
  Fountain_setup(obj, real);
  rb_iv_set(obj, '@ank', ap_iFountainColor(real.Ank, obj));
  rb_iv_set(obj, '@comment', ap_iFountainColor(real.Comment, obj));
  rb_iv_set(obj, '@int', ap_iFountainColor(real.Int, obj));
  rb_iv_set(obj, '@str', ap_iFountainColor(real.Str, obj));
  rb_iv_set(obj, '@symbol', ap_iFountainColor(real.Symbol, obj));
  rb_iv_set(obj, '@global_var', ap_iFountainColor(real.GlobalVar, obj));
  rb_iv_set(obj, '@instance_var', ap_iFountainColor(real.InstanceVar, obj));
  rb_iv_set(obj, '@class_var', ap_iFountainColor(real.ClassVar, obj));
  rb_iv_set(obj, '@constant', ap_iFountainColor(real.Constant, obj));
  rb_iv_set(obj, '@ruby_symbol', ap_iFountainColor(real.RubySymbol, obj));
  rb_iv_set(obj, '@regexp', ap_iFountainColor(real.Regexp, obj));
  rb_iv_set(obj, '@definition', ap_iFountainColor(real.Definition, obj));
end;

function RubyFountain_alloc(klass: Tvalue; real: TRubyFountain): Tvalue;
begin
  result := TmpAlloc(klass, real);
  RubyFountain_setup(result, real);
end;

function ap_iRubyFountain(real: TRubyFountain; owner: Tvalue): Tvalue;
begin
  result := RubyFountain_alloc(cRubyFountain, real);
  ap_owner(result, owner);
end;

function ap_iRubyFountain_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRubyFountain(TRubyFountain(AControl), owner)
end;

function RubyFountain_new(This: Tvalue): Tvalue; cdecl;
var
  real: TRubyFountain;
begin
  real := TRubyFountain.Create(nil);
  result := CompoAlloc(This, real);
  RubyFountain_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

procedure Init_RubyFountain;
begin
  cRubyFountain := DefinePersistentClass(ap_mPhi, TRubyFountain, cFountain, ap_iRubyFountain_v);
  DefineProp(cRubyFountain, TRubyFountain);
  rb_define_singleton_method(cRubyFountain, 'new', @RubyFountain_new, 0);
end;

end.
