unit OleHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, OleCtnrs;

type
  TOleHandle = class(TObject)
  public
    { TDrawOle }
    procedure doObjectMove(OleContainer: TOleContainer; const Bounds: TRect);
  end;

var
  Handle: TOleHandle;
  rb_eOleError, cOleContainer: Tvalue;

implementation

uses Pythia;

procedure TOleHandle.doObjectMove(OleContainer: TOleContainer; const Bounds: TRect);
var
  recv, data: Tvalue;
  rectp: PRect;
  rectv: Tvalue;
begin
  recv := OleContainer.tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_object_move'));
  rb_ary_push(data, recv);
  new(rectp);
  rectv := rb_data_object_alloc(ap_cRect, rectp, nil, @ap_dispose);
  rb_ary_push(data, rectv);
  rectp^.TopLeft := Bounds.TopLeft;
  rectp^.BottomRight := Bounds.BottomRight;
  PhiCallProtect(data);
end;

initialization
  Handle := TOleHandle.Create;
finalization
  Handle.Free;
end.
