unit uPageProducer;

interface

uses Classes, HTTPProd, Rubies;

var
  cPageProducer: Tvalue;
  vPageProducer: Tvalue;

function ap_cPageProducer: Tvalue;
function ap_iPageProducer(real: TPageProducer; owner: Tvalue): Tvalue;
function Regist_PageProducer(real: TPageProducer; owner: Tvalue): Tvalue;
procedure Init_PageProducer;

implementation

uses
  SysUtils, uDefUtils, Pythia, uWeb;

function ap_cPageProducer: Tvalue;
begin
  result := cPageProducer;
end;

procedure PageProducer_setup(obj: Tvalue; real: TPageProducer);
begin
  rb_iv_set(obj, '@html_doc', ap_iStrings(real.HTMLDoc, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
  if @real.OnHTMLTag = nil then
      real.OnHTMLTag := Handle.HTMLTagOnHTMLTag;
end;

function PageProducer_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function PageProducer_alloc(This: Tvalue; real: TPageProducer): Tvalue;
begin
  result := ChildAlloc(This, real);
  PageProducer_setup(result, real);
end;

function ap_iPageProducer(real: TPageProducer; owner: Tvalue): Tvalue;
begin
  result := PageProducer_alloc(cPageProducer, real);
  ap_owner(result, owner);
end;

function ap_iPageProducer_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPageProducer(TPageProducer(AControl), owner)
end;

function PageProducer_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPageProducer;
begin
  real := TPageProducer.Create(nil);
  result := CompoAlloc(This, real);
  PageProducer_setup(result, real);
end;

function Regist_PageProducer(real: TPageProducer; owner: Tvalue): Tvalue;
begin
  result := ap_iPageProducer(real, Qnil);
  vPageProducer := result;
  rb_define_const(mWeb, 'PRODUCER', result);
  PageProducer_setup(result, real);
end;

function PageProducer_content(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TPageProducer;
begin
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  if argc < 1 then
    result := ap_String(real.Content)
  else
    result := ap_String(real.ContentFromString(dl_String(args[0])));
end;

procedure Init_PageProducer;
begin
  DefineConstSetType(mWeb, TypeInfo(TTag));
  cPageProducer := rb_define_class_under(mWeb, 'PageProducer', ap_cComponent);
  rb_define_method(cPageProducer, 'event_handle', @PageProducer_event_handle, 1);
  rb_define_alloc_func(cPageProducer, @PageProducer_allocate);
  DefineProp(cPageProducer, TPageProducer);
  rb_define_method(cPageProducer, 'content', @PageProducer_content, -1);
end;

exports
  Regist_PageProducer;

end.
