require "test/unit"
require "phi"
class TCTreeNode < Test::Unit::TestCase
  #def test_new
  #  assert_raise(NoMethodError) { Phi::TreeNode.new }
  #end
  def test_ancestors
    assert_equal Phi::Persistent, Phi::TreeNode.superclass
  end
end

class TCTreeNodes < Test::Unit::TestCase
  #def test_new
  #  assert_raise(NoMethodError) { Phi::TreeNodes.new }
  #end
  def test_ancestors
    assert_equal Phi::Persistent, Phi::TreeNodes.superclass
  end

  def test_count
    form = Phi::Form.new
    lv = Phi::TreeView.new form
    nodes = lv.items
    assert_equal 0, nodes.count
  end

  def test_load_from_stream
    form = Phi::Form.new
    tv = Phi::TreeView.new form
    stream = Phi::StringStream.new <<EOS
US Headquarters
\tBoard of Directors
\t\tMonica Ross
\t\t\tUS Offices
\t\t\t\tEuropean Offices
\t\t\t\t\tLondon
\t\t\t\t\t\tJoe Winkler
\t\t\t\t\t\tMarion Kim
\t\t\t\t\tMilan
\t\t\t\t\t\tPaolo Rossi
\t\t\t\t\t\tAndrea bianchi
\t\t\t\t\tFrankfurt
\t\t\t\t\t\tHans Weber
\t\t\t\t\t\t
\t\t\t\t\tMoscow
\t\t\t\tNew York
\t\t\t\t\tMark Wright
\t\t\t\t\tJohn Reynolds
\t\t\t\tSan Francisco
\t\t\t\t\tMary Farrell
\t\t\t\t\tJJD
\t\t\t\tAtlanta
\t\t\t\t\tChris Morgan
\t\t\t\t\tPaula Read
\t\t\t\t\tSteve Marigo
\tMarketing
\t\tSteve Rubens
\tSales
\t\tFar East
\t\t\tParis
\t\t\t\tFrancois Martoni
\t\t\t\tJeanette Moret
\t\t\tTokio
\t\t\t\tSingapore
\t\t\t\t\tTerry Merks
\t\t\t\t\t\tEddie Flint
\t\t\t\t\t\t\tKim Seh Joh
\t\t\t\tMen Caraci
\t\t\tSidney
\t\t\t\tJohn Calgary
\t\t\t\tMark Reen
\t\tJohn Reiter
\tAdministration
\t\tArgentina
\t\t\tBuenos Aires
\t\tIan Green
\t\t\tBen Parry
\tPartners
\t\tBrasil
\t\t\tRio De Janueiro
\t\t\tSao Paulo
\t\tMexico
\t\t\tMexico City
\tR&D
\t\tMichael Tour
\tSupport
\t\tTony Gar
EOS
    tv.load stream
    nodes = tv.items
    assert_instance_of Phi::TreeView, nodes.owner
    assert_equal tv, nodes.owner
    assert_equal 57, nodes.count

    first_node = nodes.first_node
    assert_equal "US Headquarters", first_node.text
    assert_equal 0, first_node.index
    assert_equal 0, first_node.level
    assert_nil first_node.parent
    assert_instance_of Phi::TreeNodes, first_node.owner
    assert_instance_of Phi::TreeView, first_node.owner.owner
    assert_equal nodes, first_node.owner
    assert_nil first_node.data
    assert_equal 7, first_node.count

    first_child = first_node.first_child
    assert_equal "Board of Directors", first_child.text
    assert_equal 0, first_child.index
    assert_equal 1, first_child.level

    nodes.delete(first_child)
    assert_equal 33, nodes.count

    nodes.delete(first_node)
    assert_equal 0, nodes.count

    nodes.clear
    assert_equal 0, nodes.count
  end
end
