unit uActionMainMenuBar;

{$I heverdef.inc}

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ActnCtrls,
  ActnMenus,
{$IFDEF DELPHI7_UP}
  XPStyleActnCtrls,
{$ENDIF}
  Rubies;


var
  cActionMainMenuBar: Tvalue;

function ap_cActionMainMenuBar: Tvalue;
function ap_iActionMainMenuBar(real: TActionMainMenuBar; owner: Tvalue): Tvalue;
procedure Init_ActionMainMenuBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cActionMainMenuBar: Tvalue;
begin
  result := cActionMainMenuBar;
end;

procedure ActionMainMenuBar_setup(obj: Tvalue; real: TActionMainMenuBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ActionMainMenuBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ActionMainMenuBar_alloc(This: Tvalue; real: TActionMainMenuBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  ActionMainMenuBar_setup(result, real);
end;

function ap_iActionMainMenuBar(real: TActionMainMenuBar; owner: Tvalue): Tvalue;
begin
  result := ActionMainMenuBar_alloc(cActionMainMenuBar, real);
  ap_owner(result, owner);
end;

function ap_iActionMainMenuBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iActionMainMenuBar(TActionMainMenuBar(AControl), owner);
end;

function ActionMainMenuBar_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TActionMainMenuBar;
begin
  real := TActionMainMenuBar.Create(nil);
  result := CompoAlloc(This, real);
  ActionMainMenuBar_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ActionMainMenuBar = class(TActionMainMenuBar)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ActionMainMenuBar_get_inactive(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Inactive);  
end;

function ActionMainMenuBar_set_inactive(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  real.Inactive := dl_Boolean(v);
  result := v;
end;

function ActionMainMenuBar_close_menu(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  real.CloseMenu;
  result := This;
end;

function ActionMainMenuBar_track_menu(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  real.TrackMenu;
  result := This;
end;

function ActionMainMenuBar_get_expand_delay(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ExpandDelay);  
end;

function ActionMainMenuBar_set_expand_delay(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  real.ExpandDelay := dl_Integer(v);
  result := v;
end;

function ActionMainMenuBar_get_in_menu_loop(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.InMenuLoop);  
end;

function ActionMainMenuBar_set_in_menu_loop(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionMainMenuBar;
begin
  real := ap_data_get_struct(This);
  real.InMenuLoop := dl_Boolean(v);
  result := v;
end;

(**** made by ap_src_maker ****)

procedure Init_ActionMainMenuBar;
begin
  cActionMainMenuBar := OutputPersistentClass(mPhi, TActionMainMenuBar, cWinControl, ap_iActionMainMenuBar_v);
  rb_define_method(cActionMainMenuBar, 'event_handle', @ActionMainMenuBar_event_handle, 1);
  rb_define_alloc_func(cActionMainMenuBar, @ActionMainMenuBar_allocate);

(**** str_init made by ap_src_maker ****)
//  TCustomActionMainMenuBar = class(TCustomActionMenuBar)

  DefineAttrGet(cActionMainMenuBar, 'inactive', ActionMainMenuBar_get_inactive);
  rb_define_alias(cActionMainMenuBar , 'inactive?', 'inactive');
  DefineAttrSet(cActionMainMenuBar, 'inactive', ActionMainMenuBar_set_inactive);

//  TCustomActionMenuBar = class(TCustomActionDockBar)

  rb_define_method(cActionMainMenuBar, 'close_menu', @ActionMainMenuBar_close_menu, 0);
  rb_define_method(cActionMainMenuBar, 'track_menu', @ActionMainMenuBar_track_menu, 0);
//  DefineAttrGet(cActionMainMenuBar, 'animation_style', ActionMainMenuBar_get_animation_style);
//  DefineAttrSet(cActionMainMenuBar, 'animation_style', ActionMainMenuBar_set_animation_style);
  DefineAttrGet(cActionMainMenuBar, 'expand_delay', ActionMainMenuBar_get_expand_delay);
  DefineAttrSet(cActionMainMenuBar, 'expand_delay', ActionMainMenuBar_set_expand_delay);
  DefineAttrGet(cActionMainMenuBar, 'in_menu_loop', ActionMainMenuBar_get_in_menu_loop);
  rb_define_alias(cActionMainMenuBar , 'in_menu_loop?', 'in_menu_loop');
  DefineAttrSet(cActionMainMenuBar, 'in_menu_loop', ActionMainMenuBar_set_in_menu_loop);
//  DefineAttrGet(cActionMainMenuBar, 'parent_control', ActionMainMenuBar_get_parent_control);
//  DefineAttrSet(cActionMainMenuBar, 'parent_control', ActionMainMenuBar_set_parent_control);
//  DefineAttrGet(cActionMainMenuBar, 'root_menu', ActionMainMenuBar_get_root_menu);
//  DefineAttrSet(cActionMainMenuBar, 'root_menu', ActionMainMenuBar_set_root_menu);
(**** made by ap_src_maker ****)

end;

end.
