unit uComboBoxEx;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ExtCtrls,
  Rubies;

var
  cComboBoxEx: Tvalue;

function ap_cComboBoxEx: Tvalue;
function ap_iComboBoxEx(real: TComboBoxEx; owner: Tvalue): Tvalue;
procedure Init_ComboBoxEx;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cComboBoxEx: Tvalue;
begin
  result := cComboBoxEx;
end;

procedure ComboBoxEx_setup(obj: Tvalue; real: TComboBoxEx);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ComboBoxEx_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ComboBoxEx_alloc(This: Tvalue; real: TComboBoxEx): Tvalue;
begin
  result := ChildAlloc(This, real);
  ComboBoxEx_setup(result, real);
end;

function ap_iComboBoxEx(real: TComboBoxEx; owner: Tvalue): Tvalue;
begin
  result := ComboBoxEx_alloc(cComboBoxEx, real);
  ap_owner(result, owner);
end;

function ap_iComboBoxEx_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iComboBoxEx(TComboBoxEx(AControl), owner);
end;

function ComboBoxEx_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBoxEx;
begin
  real := TComboBoxEx.Create(nil);
  result := CompoAlloc(This, real);
  ComboBoxEx_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ComboBoxEx = class(TComboBoxEx)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ComboBoxEx_get_drop_down_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ComboBoxEx;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.DropDownCount);
end;

function ComboBoxEx_set_drop_down_count(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ComboBoxEx;
begin
  real := ap_data_get_struct(This);
  real.DropDownCount := dl_Integer(v);
  result := v;
end;

function ComboBoxEx_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ComboBoxEx;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

function ComboBoxEx_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ComboBoxEx;
begin
  real := ap_data_get_struct(This);
  real.SelText := dl_String(v);
  result := v;
end;

(**** made by ap_src_maker ****)


procedure Init_ComboBoxEx;
begin
  cComboBoxEx := OutputPersistentClass(mPhi, TComboBoxEx, cWinControl, ap_iComboBoxEx_v);
  rb_define_method(cComboBoxEx, 'event_handle', @ComboBoxEx_event_handle, 1);
  rb_define_alloc_func(cComboBoxEx, @ComboBoxEx_allocate);

(**** str_init made by ap_src_maker ****)
  DefineAttrGet(cComboBoxEx, 'drop_down_count', ComboBoxEx_get_drop_down_count);
  DefineAttrSet(cComboBoxEx, 'drop_down_count', ComboBoxEx_set_drop_down_count);
//  DefineAttrGet(cComboBoxEx, 'images', ComboBoxEx_get_images);
//  DefineAttrSet(cComboBoxEx, 'images', ComboBoxEx_set_images);
//  DefineAttrGet(cComboBoxEx, 'items_ex', ComboBoxEx_get_items_ex);
//  DefineAttrSet(cComboBoxEx, 'items_ex', ComboBoxEx_set_items_ex);
  DefineAttrGet(cComboBoxEx, 'sel_text', ComboBoxEx_get_sel_text);
  DefineAttrSet(cComboBoxEx, 'sel_text', ComboBoxEx_set_sel_text);
//  DefineAttrGet(cComboBoxEx, 'style', ComboBoxEx_get_style);
//  DefineAttrSet(cComboBoxEx, 'style', ComboBoxEx_set_style);
//  DefineAttrGet(cComboBoxEx, 'style_ex', ComboBoxEx_get_style_ex);
//  DefineAttrSet(cComboBoxEx, 'style_ex', ComboBoxEx_set_style_ex);
(**** made by ap_src_maker ****)


end;

end.
