unit uDdeClientConv;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  DdeMan,
  Rubies;

var
  cDdeClientConv: Tvalue;

function ap_cDdeClientConv: Tvalue;
function ap_iDdeClientConv(real: TDdeClientConv; owner: Tvalue): Tvalue;
procedure Init_DdeClientConv;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cDdeClientConv: Tvalue;
begin
  result := cDdeClientConv;
end;

procedure DdeClientConv_setup(obj: Tvalue; real: TDdeClientConv);
begin
//    AssignPropMethod(real, [Handle]);
end;

function DdeClientConv_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function DdeClientConv_alloc(This: Tvalue; real: TDdeClientConv): Tvalue;
begin
  result := ChildAlloc(This, real);
  DdeClientConv_setup(result, real);
end;

function ap_iDdeClientConv(real: TDdeClientConv; owner: Tvalue): Tvalue;
begin
  result := DdeClientConv_alloc(cDdeClientConv, real);
  ap_owner(result, owner);
end;

function ap_iDdeClientConv_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDdeClientConv(TDdeClientConv(AControl), owner);
end;

function DdeClientConv_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TDdeClientConv;
begin
  real := TDdeClientConv.Create(nil);
  result := CompoAlloc(This, real);
  DdeClientConv_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_DdeClientConv = class(TDdeClientConv)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function DdeClientConv_paste_link(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.PasteLink);
end;

function DdeClientConv_open_link(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.OpenLink);
end;

function DdeClientConv_set_link(This, Service, Topic : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
  dlv_Service : string;
  dlv_Topic : string;
begin
  real := ap_data_get_struct(This);
  dlv_Service := dl_String(Service);
  dlv_Topic := dl_String(Topic);
  result := ap_Bool(real.SetLink( dlv_Service, dlv_Topic ));
end;

function DdeClientConv_close_link(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  real.CloseLink;
  result := This;
end;

function DdeClientConv_start_advise(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.StartAdvise);
end;

function DdeClientConv_poke_data_lines(This, Item, Data : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
  dlv_Item : string;
  dlv_Data : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_Item := dl_String(Item);
  dlv_Data := ap_data_get_struct(Data);
  result := ap_Bool(real.PokeDataLines( dlv_Item, dlv_Data ));
end;

function DdeClientConv_poke_data(This, Item, Data : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
  dlv_Item : string;
  dlv_Data : PChar;
begin
  real := ap_data_get_struct(This);
  dlv_Item := dl_String(Item);
  dlv_Data := ap_data_get_struct(Data);
  result := ap_Bool(real.PokeData( dlv_Item, dlv_Data ));
end;

function DdeClientConv_execute_macro_lines(This, Cmd, waitFlg : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
  dlv_Cmd : TStrings;
  dlv_waitFlg : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_Cmd := ap_data_get_struct(Cmd);
  dlv_waitFlg := dl_Boolean(waitFlg);
  result := ap_Bool(real.ExecuteMacroLines( dlv_Cmd, dlv_waitFlg ));
end;

function DdeClientConv_execute_macro(This, Cmd, waitFlg : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
  dlv_Cmd : PChar;
  dlv_waitFlg : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_Cmd := ap_data_get_struct(Cmd);
  dlv_waitFlg := dl_Boolean(waitFlg);
  result := ap_Bool(real.ExecuteMacro( dlv_Cmd, dlv_waitFlg ));
end;

function DdeClientConv_get_dde_fmt(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.DdeFmt);  
end;

function DdeClientConv_get_wait_stat(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeClientConv;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.WaitStat);  
end;

(**** made by ap_src_maker ****)

procedure Init_DdeClientConv;
begin
  cDdeClientConv := OutputPersistentClass(mPhi, TDdeClientConv, cComponent, ap_iDdeClientConv_v);
  rb_define_method(cDdeClientConv, 'event_handle', @DdeClientConv_event_handle, 1);
  rb_define_alloc_func(cDdeClientConv, @DdeClientConv_allocate);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cDdeClientConv, 'paste_link', @DdeClientConv_paste_link, 0);
  rb_define_method(cDdeClientConv, 'open_link', @DdeClientConv_open_link, 0);
  rb_define_method(cDdeClientConv, 'set_link', @DdeClientConv_set_link, 2);
  rb_define_method(cDdeClientConv, 'close_link', @DdeClientConv_close_link, 0);
  rb_define_method(cDdeClientConv, 'start_advise', @DdeClientConv_start_advise, 0);
  rb_define_method(cDdeClientConv, 'poke_data_lines', @DdeClientConv_poke_data_lines, 2);
  rb_define_method(cDdeClientConv, 'poke_data', @DdeClientConv_poke_data, 2);
  rb_define_method(cDdeClientConv, 'execute_macro_lines', @DdeClientConv_execute_macro_lines, 2);
  rb_define_method(cDdeClientConv, 'execute_macro', @DdeClientConv_execute_macro, 2);
//  rb_define_method(cDdeClientConv, 'request_data', @DdeClientConv_request_data, 1);
  DefineAttrGet(cDdeClientConv, 'dde_fmt', DdeClientConv_get_dde_fmt);
  DefineAttrGet(cDdeClientConv, 'wait_stat', DdeClientConv_get_wait_stat);
  rb_define_alias(cDdeClientConv , 'wait_stat?', 'wait_stat');
//  DefineAttrGet(cDdeClientConv, 'conv', DdeClientConv_get_conv);
//  DefineAttrGet(cDdeClientConv, 'data_mode', DdeClientConv_get_data_mode);
//  DefineAttrSet(cDdeClientConv, 'data_mode', DdeClientConv_set_data_mode);
(**** made by ap_src_maker ****)

end;

end.
