unit uGraphic;

interface

uses
  Windows,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  Rubies;

var
  cGraphic: Tvalue;

function ap_cGraphic: Tvalue;
function ap_iGraphic(real: TGraphic; owner: Tvalue): Tvalue;  //++
procedure Init_Graphic;

implementation

uses
  Classes, SysUtils,
  uDefUtils, uIntern, uAlloc, uProp, uPhi, uConv, uPersistent;

(**** str_my_class made by ap_src_maker ****)
type
TMyGraphic = class(TGraphic)
end;
(**** made by ap_src_maker ****)

function ap_cGraphic: Tvalue;
begin
  result := cGraphic;
end;

procedure Graphic_setup(obj: Tvalue; real: TGraphic);
begin
end;

function Graphic_alloc(klass: Tvalue; real: TGraphic): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Graphic_setup(result, real);
end;

function ap_iGraphic(real: TGraphic; owner: Tvalue): Tvalue;
begin
  result := Graphic_alloc(cGraphic, real);
  ap_owner(result, owner);
end;

function Graphic_get_width(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Integer(TGraphic(ap_data_get_struct(This)).Width);
end;

function Graphic_set_width(This, v: Tvalue): Tvalue; cdecl;
begin
  TGraphic(ap_data_get_struct(This)).Width := dl_Integer(v);
  result := v;
end;

function Graphic_get_height(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Integer(TGraphic(ap_data_get_struct(This)).Height);
end;

function Graphic_set_height(This, v: Tvalue): Tvalue; cdecl;
begin
  TGraphic(ap_data_get_struct(This)).Height := dl_Integer(v);
  result := v;
end;

function Graphic_get_empty(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(TGraphic(ap_data_get_struct(This)).Empty);
end;

(**** str_method made by ap_src_maker ****)
function Graphic_load_from_file(This, Filename : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_Filename : string;
begin
  real := ap_data_get_struct(This);
  dlv_Filename := dl_String(Filename);
  real.LoadFromFile( dlv_Filename );
  result := This;
end;

function Graphic_save_to_file(This, Filename : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_Filename : string;
begin
  real := ap_data_get_struct(This);
  dlv_Filename := dl_String(Filename);
  real.SaveToFile( dlv_Filename );
  result := This;
end;

function Graphic_load_from_stream(This, Stream : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_Stream : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_Stream := ap_data_get_struct(Stream);
  real.LoadFromStream( dlv_Stream );
  result := This;
end;

function Graphic_save_to_stream(This, Stream : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_Stream : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_Stream := ap_data_get_struct(Stream);
  real.SaveToStream( dlv_Stream );
  result := This;
end;
{$IFDEF VCL}
function Graphic_load_from_clipboard_format(This, AFormat, AData, APalette : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_AFormat : Word;
  dlv_AData : THandle;
  dlv_APalette : HPALETTE;
begin
  real := ap_data_get_struct(This);
  dlv_AFormat := dl_Integer(AFormat);
  dlv_AData := THandle(dl_Handle(AData));
  dlv_APalette := HPALETTE(dl_Handle(APalette));
  real.LoadFromClipboardFormat( dlv_AFormat, dlv_AData, dlv_APalette );
  result := This;
end;

function Graphic_save_to_clipboard_format(This, AFormat, AData, APalette : Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
  dlv_AFormat : Word;
  dlv_AData : THandle;
  dlv_APalette : HPALETTE;
begin
  real := ap_data_get_struct(This);
  dlv_AFormat := dl_Integer(AFormat);
  dlv_AData := THandle(dl_Handle(AData));
  dlv_APalette := HPALETTE(dl_Handle(APalette));
  real.SaveToClipboardFormat( dlv_AFormat, dlv_AData, dlv_APalette );
  result := This;
end;
{$ENDIF}
function Graphic_get_modified(This: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Modified);  
end;

function Graphic_set_modified(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  real.Modified := dl_Boolean(v);
  result := v;
end;
{$IFDEF VCL}
function Graphic_get_palette(This: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.Palette));  
end;

function Graphic_set_palette(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  real.Palette := HPALETTE(dl_Handle(v));
  result := v;
end;

function Graphic_get_palette_modified(This: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.PaletteModified);  
end;

function Graphic_set_palette_modified(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  real.PaletteModified := dl_Boolean(v);
  result := v;
end;
{$ENDIF}
function Graphic_get_transparent(This: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Transparent);  
end;

function Graphic_set_transparent(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyGraphic;
begin
  real := ap_data_get_struct(This);
  real.Transparent := dl_Boolean(v);
  result := v;
end;
(**** made by ap_src_maker ****)

procedure Init_Graphic;
begin
  cGraphic := rb_define_class_under(mPhi, 'Graphic', ap_cPersistent);
  OutputProp(cGraphic, TGraphic);

  DefineAttrSet(cGraphic, 'width', Graphic_set_width);
  DefineAttrGet(cGraphic, 'width', Graphic_get_width);
  DefineAttrSet(cGraphic, 'height', Graphic_set_height);
  DefineAttrGet(cGraphic, 'height', Graphic_get_height);
  DefineAttrGet(cGraphic, 'empty', Graphic_get_empty);
  rb_define_alias(cGraphic, 'empty?', 'empty');

(**** str_init made by ap_src_maker ****)
  rb_define_method(cGraphic, 'load_from_file', @Graphic_load_from_file, 1);
  rb_define_method(cGraphic, 'save_to_file', @Graphic_save_to_file, 1);
  rb_define_method(cGraphic, 'load_from_stream', @Graphic_load_from_stream, 1);
  rb_define_method(cGraphic, 'save_to_stream', @Graphic_save_to_stream, 1);
{$IFDEF VCL}
  rb_define_method(cGraphic, 'load_from_clipboard_format', @Graphic_load_from_clipboard_format, 3);
  rb_define_method(cGraphic, 'save_to_clipboard_format', @Graphic_save_to_clipboard_format, 3);
{$ENDIF}
  DefineAttrGet(cGraphic, 'modified', Graphic_get_modified);
  DefineAttrGet(cGraphic, 'modified?', Graphic_get_modified);
  DefineAttrSet(cGraphic, 'modified', Graphic_set_modified);
{$IFDEF VCL}
  DefineAttrGet(cGraphic, 'palette', Graphic_get_palette);
  DefineAttrSet(cGraphic, 'palette', Graphic_set_palette);
  DefineAttrGet(cGraphic, 'palette_modified', Graphic_get_palette_modified);
  DefineAttrGet(cGraphic, 'palette_modified?', Graphic_get_palette_modified);
  DefineAttrSet(cGraphic, 'palette_modified', Graphic_set_palette_modified);
{$ENDIF}
  DefineAttrGet(cGraphic, 'transparent', Graphic_get_transparent);
  DefineAttrGet(cGraphic, 'transparent?', Graphic_get_transparent);
  DefineAttrSet(cGraphic, 'transparent', Graphic_set_transparent);
(**** made by ap_src_maker ****)
end;

end.
