unit uPageControl;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cPageControl: Tvalue;

function ap_cPageControl: Tvalue;
function ap_iPageControl(real: TPageControl; owner: Tvalue): Tvalue;
procedure Init_PageControl;

implementation

uses
  SysUtils, Classes,
  uConv,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

type TMyPageControl = class(TPageControl);

function ap_cPageControl: Tvalue;
begin
  result := cPageControl;
end;

procedure PageControl_setup(obj: Tvalue; real: TPageControl);
begin
//    AssignPropMethod(real, [Handle]);
end;

function PageControl_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function PageControl_alloc(This: Tvalue; real: TPageControl): Tvalue;
begin
  result := ChildAlloc(This, real);
  PageControl_setup(result, real);
end;

function ap_iPageControl(real: TPageControl; owner: Tvalue): Tvalue;
begin
  result := PageControl_alloc(cPageControl, real);
  ap_owner(result, owner);
end;

function ap_iPageControl_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPageControl(TPageControl(AControl), owner);
end;

function PageControl_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
begin
  real := TPageControl.Create(nil);
  result := CompoAlloc(This, real);
  PageControl_setup(result, real);
end;

function PageControl_select_next_page(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
  GoForward: Boolean;
begin
  if argc > 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  if argc = 1 then
    GoForward := RTEST(Pvalue(argv)^)
  else
    GoForward := True;
  real := ap_data_get_struct(This);
  real.SelectNextPage(GoForward);
  result := This;
end;

function PageControl_find_next_page(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TPageControl;
  CurPage: TTabSheet;
  GoForward: Boolean;
  CheckTabVisible: Boolean;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  if argc > 3 then ap_raise(ap_eArgError, sWrong_num_of_args);
  SetLength(args, argc);
  args := argv;
  ap_data_get_object(args[0], TTabSheet, CurPage);
  if argc > 1 then
    GoForward := RTEST(args[1])
  else
    GoForward := True;
  if argc > 2 then
    CheckTabVisible := RTEST(args[2])
  else
    CheckTabVisible := True;
  real := ap_data_get_struct(This);
  real.FindNextPage(CurPage, GoForward, CheckTabVisible);
  result := This;
end;

function PageControl_pages(This, i: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(i);
  result := This;
  try
    result := real.Pages[n].tag;
  except
    on E: Exception do
      ap_raise(ap_eArgError, PChar(E.message));
  end;
end;

function PageControl_get_page_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.PageCount);
end;

(**** str2 made by ap_src_maker ****)

function PageControl_can_show_tab(This, TabIndex : Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
  dl_TabIndex : Integer;
begin
  real := ap_data_get_struct(This);
  dl_TabIndex := dl_Integer(TabIndex);
  result := ap_Bool(real.CanShowTab( dl_TabIndex ));
end;

function PageControl_change(This : Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
begin
  real := ap_data_get_struct(This);
  real.Change;
  result := This;
end;

function PageControl_get_image_index(This, TabIndex : Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
  dl_TabIndex : Integer;
begin
  real := ap_data_get_struct(This);
  dl_TabIndex := dl_Integer(TabIndex);
  result := ap_Integer(real.GetImageIndex( dl_TabIndex ));
end;

function PageControl_loaded(This : Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
begin
  real := ap_data_get_struct(This);
  real.Loaded;
  result := This;
end;

function PageControl_update_active_page(This : Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
begin
  real := ap_data_get_struct(This);
  real.UpdateActivePage;
  result := This;
end;

function PageControl_get_active_page_index(This: Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ActivePageIndex);
end;

function PageControl_set_active_page_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyPageControl;
begin
  real := ap_data_get_struct(This);
  real.ActivePageIndex := dl_Integer(v);
  result := v;
end;

(**** made by ap_src_maker ****)

procedure Init_PageControl;
begin
  OutputConstSetType(mPhi, TypeInfo(TTabStyle));
{$IFDEF VCL}
  OutputConstSetType(mPhi, TypeInfo(TTabPosition));
{$ENDIF}
  cPageControl := OutputPersistentClass(mPhi, TPageControl, cWinControl, ap_iPageControl_v);
  rb_define_method(cPageControl, 'event_handle', @PageControl_event_handle, 1);
  rb_define_alloc_func(cPageControl, @PageControl_allocate);
  DefineMethod(cPageControl, 'select_next_page', PageControl_select_next_page);
  DefineMethod(cPageControl, 'find_next_page', PageControl_find_next_page);
  rb_define_method(cPageControl, 'pages', @PageControl_pages, 1);
  DefineAttrGet(cPageControl, 'page_count', PageControl_get_page_count);

(**** str3 made by ap_src_maker ****)
  rb_define_method(cPageControl, 'can_show_tab', @PageControl_can_show_tab, 1);
  rb_define_method(cPageControl, 'change', @PageControl_change, 0);
  rb_define_method(cPageControl, 'image_index', @PageControl_get_image_index, 1);
  rb_define_method(cPageControl, 'loaded', @PageControl_loaded, 0);
  rb_define_method(cPageControl, 'update_active_page', @PageControl_update_active_page, 0);
  DefineAttrGet(cPageControl, 'active_page_index', PageControl_get_active_page_index);
  DefineAttrSet(cPageControl, 'active_page_index', PageControl_set_active_page_index);
(**** made by ap_src_maker ****)
end;

end.
