unit uScrollBar;

interface

uses
{$IFDEF VCL}
  Forms, StdCtrls,
{$ELSE}
  QForms, QStdCtrls,
{$ENDIF}
  Rubies;

var
  cScrollBar: Tvalue;

function ap_cScrollBar: Tvalue;
function ap_iScrollBar(real: TScrollBar; owner: Tvalue): Tvalue;
procedure Init_ScrollBar;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cScrollBar: Tvalue;
begin
  result := cScrollBar;
end;

procedure ScrollBar_setup(obj: Tvalue; real: TScrollBar);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ScrollBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ScrollBar_alloc(klass: Tvalue; real: TScrollBar): Tvalue;
begin
  result := ChildAlloc(klass, real);
  ScrollBar_setup(result, real);
end;

function ap_iScrollBar(real: TScrollBar; owner: Tvalue): Tvalue;
begin
  result := ScrollBar_alloc(cScrollBar, real);
  ap_owner(result, owner);
end;

function ap_iScrollBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ScrollBar_alloc(cScrollBar, TScrollBar(AControl));
end;

function ScrollBar_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := TScrollBar.Create(nil);
  result := CompoAlloc(This, real);
  ScrollBar_setup(result, real);
end;

function ScrollBar_set_kind(This, v: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := ap_data_get_struct(This);
  real.Kind := TScrollBarKind(FIX2INT(v));
  result := v;
end;

function ScrollBar_get_kind(This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Kind));
end;

procedure Init_ScrollBar;
begin
  cScrollBar := OutputPersistentClass(mPhi, TScrollBar, cWinControl, ap_iScrollBar_v);
  rb_define_method(cScrollBar, 'event_handle', @ScrollBar_event_handle, 1);
  rb_define_alloc_func(cScrollBar, @ScrollBar_allocate);
  DefineAttrSet(cScrollBar, 'kind', ScrollBar_set_kind);
  DefineAttrGet(cScrollBar, 'kind', ScrollBar_get_kind);
end;

end.
