unit uScrollBox;

interface

uses
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

var
  cScrollBox: Tvalue;

function ap_cScrollBox: Tvalue;
function ap_iScrollBox(real: TScrollBox; owner: Tvalue): Tvalue;
procedure Init_ScrollBox;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uControlScrollBar,
  uPersistent, uComponent, uControl;

function ap_cScrollBox: Tvalue;
begin
  result := cScrollBox;
end;

procedure ScrollBox_setup(obj: Tvalue; real: TScrollBox);
begin
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@horz_scroll_bar', ap_iControlScrollBar(real.HorzScrollBar, obj));
  rb_iv_set(obj, '@vert_scroll_bar', ap_iControlScrollBar(real.VertScrollBar, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ScrollBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ScrollBox_alloc(This: Tvalue; real: TScrollBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  ScrollBox_setup(result, real);
end;

function ap_iScrollBox(real: TScrollBox; owner: Tvalue): Tvalue;
begin
  result := ScrollBox_alloc(cScrollBox, real);
  ap_owner(result, owner);
end;

function ap_iScrollBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iScrollBox(TScrollBox(AControl), owner);
end;

function ScrollBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBox;
begin
  real := TScrollBox.Create(nil);
  result := CompoAlloc(This, real);
  ScrollBox_setup(result, real);
end;

procedure Init_ScrollBox;
begin
  cScrollBox := OutputPersistentClass(mPhi, TScrollBox, cWinControl, ap_iScrollBox_v);
  rb_define_method(cScrollBox, 'event_handle', @ScrollBox_event_handle, 1);
  rb_define_alloc_func(cScrollBox, @ScrollBox_allocate);
end;

end.
