unit uSizeConstraints;

interface

uses
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  Rubies;

var
  cSizeConstraints: Tvalue;

function ap_cSizeConstraints: Tvalue;
function ap_iSizeConstraints(real: TSizeConstraints; owner: Tvalue): Tvalue;
procedure Init_SizeConstraints;

implementation

uses SysUtils, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv;

function ap_cSizeConstraints: Tvalue;
begin
  result := cSizeConstraints;
end;

procedure SizeConstraints_setup(obj: Tvalue; real: TSizeConstraints);
begin
//    AssignPropMethod(real, [Handle]);
end;

function SizeConstraints_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function SizeConstraints_alloc(klass: Tvalue; real: TSizeConstraints): Tvalue;
begin
  result := TmpAlloc(klass, real);
  SizeConstraints_setup(result, real);
end;

function ap_iSizeConstraints(real: TSizeConstraints; owner: Tvalue): Tvalue;
begin
  result := SizeConstraints_alloc(cSizeConstraints, real);
  ap_owner(result, owner);
end;

function SizeConstraints_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  Control: TControl;
  real: TSizeConstraints;
begin
  if argc <> 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  ap_data_get_object(Pvalue(argv)^, TControl, Control);
  real := TSizeConstraints.Create(Control);
  result := ObjAlloc(This, real);
  SizeConstraints_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function SizeConstraints_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TSizeConstraints;
begin
  real := TSizeConstraints(ap_data_get_struct(This));
  with real do result := ap_String(Format(
    '#<%s: min_width=%d min_height=%d max_width=%d max_height=%d>', [dl_class_name_of(This), MinWidth, MinHeight, MaxWidth, MaxHeight]));
end;

procedure Init_SizeConstraints;
begin
  cSizeConstraints := rb_define_class_under(mPhi, 'SizeConstraints', ap_cObject);
  OutputProp(cSizeConstraints, TSizeConstraints);

  rb_define_method(cSizeConstraints, 'event_handle', @SizeConstraints_event_handle, 1);
  DefineSingletonMethod(cSizeConstraints, 'new', SizeConstraints_new);
  rb_define_method(cSizeConstraints, 'to_s', @SizeConstraints_to_s, 0);
end;

end.
