unit uTextAttributes;

interface

uses
  TypInfo,
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var

  cTextAttributes: Tvalue;

function ap_cTextAttributes: Tvalue;
function ap_iTextAttributes(real: TTextAttributes; owner: Tvalue): Tvalue;
procedure Init_TextAttributes;

implementation

uses
  Classes,
  SysUtils,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  uSetUtils,
  uDefUtils, uIntern, uAlloc, uProp, uPhi, uConv,
  uPersistent;

function ap_cTextAttributes: Tvalue;
begin
  result := cTextAttributes;
end;

function TextAttributes_alloc(klass: Tvalue; real: TTextAttributes): Tvalue;
begin
  result := TmpAlloc(klass, real);
end;

function ap_iTextAttributes(real: TTextAttributes; owner: Tvalue): Tvalue;
begin
  result := TextAttributes_alloc(cTextAttributes, real);
  ap_owner(result, owner);
end;

function TextAttributes_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
  klass: Tvalue;
  Charset: TFontCharset;
  Styles: TFontStyles;
  Pitch: TFontPitch;
  S: string;
begin
  real := ap_data_get_struct(This);

  result := rb_str_new2('#');
  rb_str_cat(result, '<', 1);

  klass := CLASS_OF(This);
  klass := rb_class_path(klass);
  rb_str_concat(result, klass);
  rb_str_cat(result, ':', 1);

  ap_str_cat(result, ' name=');
  ap_str_cat(result, AnsiQuotedStr(real.Name, '"'));
  ap_str_cat(result, ' charset=');
  Charset := real.Charset;
  S := GetEnumName(TypeInfo(TFontCharset), Charset);
  ap_str_cat(result, S);
  ap_str_cat(result, ' height=');
  ap_str_cat_int(result, real.Height);
  ap_str_cat(result, ' color=');
  ap_str_cat_int(result, real.Color);
  ap_str_cat(result, ' style=');
  Styles := real.Style;
  S := SetToStr(TypeInfo(TFontStyles), Styles);
  ap_str_cat(result, S);
  ap_str_cat(result, ' pitch=');
  Pitch := real.Pitch;
  S := GetEnumName(TypeInfo(TFontPitch), Ord(Pitch));
  ap_str_cat(result, S);

  rb_str_cat(result, '>', 1);
end;

function TextAttributes_get_name(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.Name);
end;

function TextAttributes_set_name(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Name := dl_String(v);
  result := v;
end;

function TextAttributes_get_charset(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.Charset);
end;

function TextAttributes_set_charset(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Charset := dl_Integer(v);
  result := v;
end;

function TextAttributes_get_height(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.Height);
end;

function TextAttributes_set_height(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Height := dl_Integer(v);
  result := v;
end;

function TextAttributes_get_color(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.Color);
end;

function TextAttributes_set_color(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Color := dl_Integer(v);
  result := v;
end;

function TextAttributes_get_style(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
  Styles: TFontStyles;
begin
  real := ap_data_get_struct(This);
  Styles := real.Style;
  result := ap_Set(Styles);
end;

function TextAttributes_set_style(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
  i: Integer;
  Styles: TFontStyles absolute i;
begin
  real := ap_data_get_struct(This);
  i := dl_Set(v);
  real.Style := Styles;
  result := v;
end;

function TextAttributes_get_pitch(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(Ord(real.Pitch));
end;

function TextAttributes_set_pitch(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Pitch := TFontPitch(dl_Integer(v));
  result := v;
end;

function TextAttributes_get_size(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.Size);
end;

function TextAttributes_set_size(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Size := dl_Integer(v);
  result := v;
end;

function TextAttributes_assign(This, Source : Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
  dl_Source : TPersistent;
begin
  real := ap_data_get_struct(This);
  dl_Source := dl_Persistent(Source);
  real.Assign( dl_Source );
  result := This;
end;

function TextAttributes_get_protected(This: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Protected);
end;

function TextAttributes_set_protected(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  real.Protected := dl_Boolean(v);
  result := v;
end;

procedure Init_TextAttributes;
begin
//OutputConstSetType(mPhi, TypeInfo(TFontPitch));
//OutputConstSetType(mPhi, TypeInfo(TFontStyle));

//cTextAttributes := rb_define_class_under(mPhi, 'TextAttributes', ap_cObject);
//OutputProp(cTextAttributes, TTextAttributes);
  cTextAttributes := DefinePersistentClass(mPhi, TTextAttributes, ap_cPersistent, nil);

  rb_define_method(cTextAttributes, 'to_s', @TextAttributes_to_s, 0);
  DefineAttrGet(cTextAttributes, 'name', TextAttributes_get_name);
  DefineAttrSet(cTextAttributes, 'name', TextAttributes_set_name);
  DefineAttrGet(cTextAttributes, 'charset', TextAttributes_get_charset);
  DefineAttrSet(cTextAttributes, 'charset', TextAttributes_set_charset);
  DefineAttrGet(cTextAttributes, 'height', TextAttributes_get_height);
  DefineAttrSet(cTextAttributes, 'height', TextAttributes_set_height);
  DefineAttrGet(cTextAttributes, 'color', TextAttributes_get_color);
  DefineAttrSet(cTextAttributes, 'color', TextAttributes_set_color);
  DefineAttrGet(cTextAttributes, 'style', TextAttributes_get_style);
  DefineAttrSet(cTextAttributes, 'style', TextAttributes_set_style);
  DefineAttrGet(cTextAttributes, 'pitch', TextAttributes_get_pitch);
  DefineAttrSet(cTextAttributes, 'pitch', TextAttributes_set_pitch);
  DefineAttrGet(cTextAttributes, 'size', TextAttributes_get_size);
  DefineAttrSet(cTextAttributes, 'size', TextAttributes_set_size);
  rb_define_method(cTextAttributes, 'assign', @TextAttributes_assign, 1);
  DefineAttrGet(cTextAttributes, 'protected', TextAttributes_get_protected);
  DefineAttrSet(cTextAttributes, 'protected', TextAttributes_set_protected);
end;

end.
