#!/usr/bin/env ruby

text_exts = %w[
  txt
  pas
  dpr
  html
  htm
]

Func = {}

def cutcd(src)
  open(src, 'r'){|i|
    while i.gets
      next unless ~ /\bcdecl\s*;/
      next unless ~ /^\s*(?:procedure|function) ([\w\d]+)/
      name = $1
      case Func[name]
      when :exist
        Func[name] = :cdecl
      when :cdecl
        Func[name] = :error
      when :error
        #
      else
        Func[name] = :exist
      end
    end
  }
end

Dir.glob('**/*'){|entry|
  pos = entry.rindex('.')
  next if pos.nil?
  ext = entry[pos+1..-1]
  if text_exts.include? ext
    $stderr.print "cutcdecl #{entry}\n"
    cutcd entry
  end
}

fexist = open('exist.txt', 'w')
fcdecl = open('cdecl.txt', 'w')
ferror = open('error.txt', 'w')

Func.keys.sort.each{|name|
  case Func[name]
  when :exist; fexist.print name, "\n"
  when :cdecl; fcdecl.print name, "\n"
  when :error; ferror.print name, "\n"
  end
}
