/*
 * Decompiled with CFR 0.152.
 */
package plus.concurrent;

import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.channels.Channel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.util.NumHelper;

public final class SimpleQueue
extends LinkedBlockingQueue<Object>
implements Channel {
    private static final long WAIT_MILLIS = 1L;
    private final transient Writer writer = new TWriter();
    private volatile boolean isClose;

    public void append(int x) {
        super.offer(x);
    }

    public void append(Number x) {
        super.offer(NumHelper.normalise(x));
    }

    public void append(String x) {
        super.offer(x);
    }

    public <E> E apply() throws InterruptedIOException {
        E rs = null;
        try {
            while (null == rs && this.isOpen()) {
                rs = super.poll(1L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(e.getMessage());
        }
        return rs;
    }

    public double doubleValue() throws InterruptedIOException {
        Object x = this.apply();
        return null == x ? Double.MIN_VALUE : NumHelper.doubleValue(x);
    }

    @Nullable
    public String getValue() throws InterruptedIOException {
        Object x = this.apply();
        return null == x ? null : x.toString();
    }

    public int intValue() throws InterruptedIOException {
        Object x = this.apply();
        return null == x ? Integer.MIN_VALUE : NumHelper.intValue(x);
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public boolean isOpen() {
        return !this.isClose && !super.isEmpty();
    }

    @Override
    public void close() {
        this.isClose = true;
    }

    private class TWriter
    extends Writer {
        private TWriter() {
        }

        @Override
        public void close() {
            SimpleQueue.this.close();
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(@NotNull char[] buf, int off, int len) {
            if (buf == null) {
                TWriter.$$$reportNull$$$0(0);
            }
            SimpleQueue.this.append(String.valueOf(buf, off, len));
        }

        @Override
        public void write(@NotNull String x) {
            if (x == null) {
                TWriter.$$$reportNull$$$0(1);
            }
            SimpleQueue.this.append(x);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buf";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "x";
                    break;
                }
            }
            objectArray[1] = "plus/concurrent/SimpleQueue$TWriter";
            objectArray[2] = "write";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

