/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import plus.lex.Expression;
import plus.lex.Flags;
import plus.lex.Function;
import plus.lex.Keyword;
import plus.lex.LexArray;
import plus.lex.LexRegx;
import plus.lex.Node;
import plus.lex.Symbols;
import plus.lex.Term;
import plus.lex.Type;

abstract class Action
extends Expression {
    private static final Node.Print EMPTY_PRINTSTMT = new Node.Print(Keyword.toName(Keyword.SymPRINT), Function.EMPTY_ARRAY, "", "");
    private static final LexRegx rxDOSTMT = new LexRegx("^[;}\n]");
    private static final LexRegx rxOPTSTATEMENT = new LexRegx("^[;}\n]");
    private int cBREAK;
    private int cP2PID;

    Action() {
    }

    @Override
    void action() {
        this.eat("{");
        this.nl();
        while (null != this.tok && !"}".equals(this.tok)) {
            this.optStatement();
        }
        this.eat("}");
        this.nl();
    }

    private void doStmt() {
        Object[] backup = this.unloadBuffer();
        int breakCount = this.cBREAK;
        this.eat((Object)Keyword.SymDO);
        this.optSEMI();
        if (rxDOSTMT.find(this.tok)) {
            this.nl();
        } else if (Keyword.SymWHILE != this.tok) {
            if ("{".equals(this.tok)) {
                this.statement();
            } else {
                while (Keyword.SymWHILE != this.tok) {
                    this.statement();
                }
            }
        }
        this.eat((Object)Keyword.SymWHILE);
        Object e = this.logicalop();
        Object[] stmt = this.codeBuf.toArray();
        this.restoreBuffer(backup);
        this.gen(new Node.While(this.hasBreak(breakCount) ? Keyword.SyyBDO : Keyword.SymDO, e, stmt));
    }

    private Object forArgments(int n) {
        if (1 == n) {
            ++this.enableReAssign;
        }
        Object e = Function.EMPTY_ARRAY;
        if (!";".equals(this.tok) && !")".equals(this.tok)) {
            Object object = e = 2 == n ? Action.genCompare(this.expression()) : this.expression();
        }
        if (";".equals(this.tok)) {
            this.advance();
            if ("\n".equals(this.tok)) {
                this.advance();
            }
        }
        if (1 == n) {
            --this.enableReAssign;
        }
        return Type.unWrapList(e);
    }

    private void forStmt() {
        Object[] backup = this.unloadBuffer();
        int breakCount = this.cBREAK;
        this.eat((Object)Keyword.SymFOR);
        this.eat("(");
        Object e1 = this.forArgments(1);
        if (")".equals(this.tok)) {
            Object right;
            Node.YyVariable left;
            this.eat(")");
            if (e1 instanceof Node.Ass) {
                Node.Ass x = (Node.Ass)e1;
                left = new Node.NAME(x.id, x.left.name);
                right = x.right;
            } else if (e1 instanceof Node.Comp) {
                Node.Comp x = (Node.Comp)e1;
                Node.Call a = (Node.Call)x.left;
                Object o = Type.unWrapList(a.args);
                if (o instanceof Node.YyVariable) {
                    Node.YyVariable z = (Node.YyVariable)o;
                    this.assignType("ForIn", z.name, x.right, 0);
                    left = z;
                } else {
                    left = new Node.NAME(Keyword.SyyNAME, o.toString());
                }
                right = x.right;
            } else {
                throw new IllegalStateException("unmatch: " + e1);
            }
            this.optStatement();
            Object[] stmt = this.codeBuf.toArray();
            this.restoreBuffer(backup);
            Keyword forID = this.hasBreak(breakCount) ? Keyword.SyyBFOR : Keyword.SymFOR;
            this.gen(new Node.ForIn(forID, left, right, stmt));
        } else {
            Object w = this.forArgments(2);
            Object e2 = Type.isEmpty(w) ? Boolean.TRUE : w;
            Object e3 = this.forArgments(3);
            this.eat(")");
            this.optStatement();
            Object[] stmt = this.codeBuf.toArray();
            this.restoreBuffer(backup);
            Keyword forID = this.hasBreak(breakCount) ? Keyword.SyyBFOR : Keyword.SymFOR;
            this.gen(new Node.For(forID, e1, e2, e3, stmt));
        }
    }

    private boolean hasBreak(int count) {
        int breakCount = this.cBREAK - count;
        this.cBREAK -= breakCount;
        return 0 < breakCount;
    }

    private void ifStmt() {
        Object[] right;
        Object[] backup = this.unloadBuffer();
        this.eat((Object)Keyword.SymIF);
        Object e = this.logicalop();
        this.optStatement();
        Object[] left = this.unloadBuffer();
        if (Keyword.SymELSE == this.tok) {
            this.eat(this.tok);
            this.nl();
            this.optStatement();
            right = this.codeBuf.toArray();
        } else {
            right = Function.EMPTY_ARRAY;
        }
        this.restoreBuffer(backup);
        this.gen(new Node.If(Keyword.SymIF, e, left, right));
    }

    private Object logicalop() {
        return Action.genCompare("(".equals(this.tok) ? this.parenlist() : this.expression());
    }

    private void optStatement() {
        this.lexlinenumber = this.yyLexNumber;
        this.optSEMI();
        if (rxOPTSTATEMENT.find(this.tok)) {
            this.nl();
        } else {
            this.statement();
        }
    }

    Object[] pattern(boolean doEmpty) {
        Object stmt;
        if ("{".equals(this.tok)) {
            this.action();
            stmt = doEmpty && this.codeBuf.isEmpty() ? EMPTY_PRINTSTMT : this.codeBuf.toArray();
        } else {
            Object p1 = this.expression();
            Object p2 = null;
            if (",".equals(this.tok)) {
                this.eat(",");
                p2 = this.expression();
            }
            if ("{".equals(this.tok)) {
                this.action();
            }
            Object[] ex = this.codeBuf.isEmpty() ? EMPTY_PRINTSTMT : this.codeBuf.toArray();
            Object cc = null == p2 ? Action.genCompare(p1) : new Node.Comp(Integer.toString(++this.cP2PID), Action.genCompare(p1), Action.genCompare(p2));
            stmt = new Node.If(Keyword.SymIF, cc, Type.castWrapArray(ex), Function.EMPTY_ARRAY);
        }
        this.nl();
        this.codeBuf.clear();
        return Type.castWrapArray(stmt);
    }

    private void simpleStmt() {
        if (this.tok instanceof Node.Annotation) {
            this.eat(this.tok);
        } else if (Keyword.SymDELETE == this.tok) {
            this.advance();
            Object o = this.term();
            Node.YyVariable x = (Node.YyVariable)o;
            if (":".equals(this.tok)) {
                this.optType(x.name, false);
            }
            Action.updateType(x, 31, 17408);
            this.gen(new Node.Del(x));
        } else if (Keyword.SymBREAK == this.tok) {
            this.eat(this.tok);
            ++this.cBREAK;
            this.gen(new Node.Stmt(Keyword.SymBREAK, Function.EMPTY_ARRAY, 16));
        } else if (Keyword.SymCONTINUE == this.tok) {
            this.eat(this.tok);
            ++this.cBREAK;
            this.gen(new Node.Stmt(Keyword.SymCONTINUE, Function.EMPTY_ARRAY, 16));
        } else if (Keyword.SymEXIT == this.tok) {
            Object e;
            this.advance();
            Object object = e = rxOPTSTATEMENT.find(this.tok) ? Term.NUMBER_ZERO : this.expression();
            if (!Flags.isNumber(Type.getNodeType(e))) {
                this.yyWARNING("ToNUMBER: exit(" + e + ")");
                e = new Node.IncDec("NUMBER", e);
            }
            this.gen(new Node.Stmt(Keyword.SymEXIT, e, 16));
        } else if (Keyword.SymRETURN == this.tok) {
            this.advance();
            ++this.cRETURN;
            Object e = rxOPTSTATEMENT.find(this.tok) ? Function.EMPTY_ARRAY : this.expression();
            Object ex = this.assignType("RETURN", this.functionId, e, 0);
            if (524323 == Symbols.getType(this.functionId)) {
                Symbols.setType(this.functionId, 16415, 0);
            }
            this.gen(new Node.Stmt(Keyword.SymRETURN, ex, Type.getNodeType(ex)));
        } else if (Keyword.SymNEXT == this.tok) {
            this.eat(this.tok);
            this.gen(new Node.Stmt(Keyword.SymNEXT, Function.EMPTY_ARRAY, 16));
        } else if (Keyword.SymNEXTFILE == this.tok) {
            this.eat(this.tok);
            this.gen(new Node.Stmt(Keyword.SymNEXTFILE, Function.EMPTY_ARRAY, 16));
        } else if (Keyword.SymTHROW == this.tok) {
            this.advance();
            Object e = this.expression();
            this.gen(new Node.Throw(e));
        } else {
            this.gen(this.expression());
        }
    }

    private void statement() {
        Object x;
        if (this.hasComment()) {
            this.gen(new Node.Comment(this.getComment().mkString("//", "\n\t//", "")));
        }
        if ("{".equals(x = this.tok)) {
            this.eat("{");
            this.nl();
            while (null != this.tok && !"}".equals(this.tok)) {
                this.statement();
            }
            this.eat("}");
        } else if (Keyword.SymIF == x) {
            this.ifStmt();
        } else if (Keyword.SymFOR == x) {
            this.forStmt();
        } else if (Keyword.SymDO == x) {
            this.doStmt();
        } else if (Keyword.SymWHILE == x) {
            this.whileStmt();
        } else if (Keyword.SymTRY == x) {
            this.tryCatchStmt();
        } else if (Keyword.SymFUNCTION == x) {
            this.eat(this.tok);
            this.functionDecl();
        } else {
            this.simpleStmt();
        }
        this.nl();
    }

    private void tryCatchStmt() {
        LexArray<Node.Catch> catchs = new LexArray<Node.Catch>();
        Object[] backup = this.unloadBuffer();
        this.eat((Object)Keyword.SymTRY);
        this.optStatement();
        Object[] trystmt = this.unloadBuffer();
        while (Keyword.SymCATCH == this.tok) {
            Object xx;
            LexArray<String> exceptions = new LexArray<String>();
            this.eat(this.tok);
            this.eat("(");
            while (true) {
                Term.BOXING claz;
                if (null == (claz = Action.classNameOrNull(xx = this.tok))) {
                    throw new IllegalArgumentException("Var type mistake! '" + xx + "' " + xx.getClass());
                }
                this.eat(this.tok);
                exceptions.add(claz.value.toString());
                if (!"|".equals(this.tok)) break;
                this.eat("|");
            }
            xx = this.tok;
            if (!(xx instanceof Node.NAME)) {
                throw new IllegalArgumentException("Var type mistake! '" + xx + "' " + xx.getClass());
            }
            Node.NAME ex = (Node.NAME)xx;
            this.eat(this.tok);
            this.eat(")");
            Symbols.createType(ex.name);
            Symbols.setType(ex.name, 31, 16384);
            this.optStatement();
            Object[] catstmt = this.unloadBuffer();
            catchs.add(new Node.Catch(ex.name, exceptions.toArray(new String[0]), catstmt));
        }
        if (Keyword.SymFINALLY == this.tok) {
            this.eat(this.tok);
            this.optStatement();
        }
        Object[] finalstmt = this.unloadBuffer();
        Node.Try w = new Node.Try(trystmt, catchs.toArray(new Node.Catch[0]), finalstmt);
        this.restoreBuffer(backup);
        this.gen(w);
    }

    private void whileStmt() {
        Object[] backup = this.unloadBuffer();
        int breakCount = this.cBREAK;
        this.eat((Object)Keyword.SymWHILE);
        Object e = this.logicalop();
        this.optStatement();
        Object[] stmt = this.codeBuf.toArray();
        this.restoreBuffer(backup);
        this.gen(new Node.While(this.hasBreak(breakCount) ? Keyword.SyyBWHILE : Keyword.SymWHILE, e, stmt));
    }
}

