/** AWK~plus - Side Effects.
 */
# @TypeChecked
BEGIN {
    java7
    brackets
    loop
    string
    side
    print '.'
}
function java7() {
    print "   .java7"
    val a = 0b1_1101;   assertEquals(29, a)
    val b = 0_17;       assertEquals(15, b)
    val c = 0x1_c;      assertEquals(28, c)
    val d = 1_234;      assertEquals(1234, d)
    val e = .123_45;    assertEquals(0.12345, e)
    val f = .123_45e_1; assertEquals(1.2345, f)
    val g = 6_.7890;    assertEquals(6.7890, g)
    print "\t.java7", a, b, c, d, e, f, g
}
function brackets() {
    print "   .brackets"
    function sum(a, b, c) { return a + b + c }
    assertEquals(6, sum(1, 2, 3))
    assertEquals(9, sum(2, 3)(4))   # '()'u
    assertEquals(12, sum(3)(4){5})  # '{}'u
}
function loop() {
    # Groovy ɂ́Ado whileƂ̂́Ass`.
    print "   .do while - for Groovy."
    var sum = i = 0
    do sum += ++i while (10 > i)
    assertEquals(55, sum)
    assertTrue(55 == sum, "!")

    print "   .loop - for Interpreter."
    for (;;) break
    for (i = 0; ++i;) if (10 == i) break else continue
    assertEquals(10, i)
    # while break
    while (--i) if (5 == i) break else continue
    assertEquals(5, i)
}
function string() {
    print "   .String"
    val s1 = /"'(\/[^"]|\\")*"/
    val s2 = '"\'(/[^"]|\\")*"'
    val s3 = "\"'(/[^\"]|\\\")*\""
    val s4 = """"'(/[^"]|\\")*"\
        |"""
    # R[h́AInterpreter: "...", Compiler: '...'.
    print "\t1.", s1, "Regular expression"
    print "\t2.", s2, "Single quote"
    print "\t3.", s3, "Double quote"
    print "\t4.", s4, "Here Document"
    assertEquals(s1, s2, "#1,#2")
    assertEquals(s2, s3, "#2,#3")
    assertEquals(s2, s4, "#2,#4")
}
function side() {
    function sideEffect(a, b) { return(b - a) }
    print "   .Side Effects"
    # E֐Ăяop[^́A߂܂.
    # EGroovýAZqI[o[[h̓sŁA
    #  CNgEfNgOu邽߁Aʂ͈v܂.
    print "\t.Function call parameters are interpreted from the back."
    print "\t.Groovy, due to operator overloading,"
    print "\t The result does not match because it pre-processes the increment/decrement."
    var i = 2
    assertEquals(0, sideEffect(i, ++i), "Plus:0, Groovy:0")
    assertEquals(-1, sideEffect(i, i++), "Plus:-1, Groovy:0", "'This is a WARNING'")
}