/** AWK~plus - Mutable.
 */
@CompileStatic  # 型推論をクラスファイルに反映
BEGIN {
    array
    sort
    mutable
    print "."
}
function array() {
    print "   .Arrays."
    val A = new AtomicArray()
    val M = new AtomicMap()
    A[1] = M[1] = "a"
    A[3] = M[3] = "c"
    # Groovy　の出力内容に注目.(不思議な List です)
    # Pay attention to the output content of Groovy. (It is a mysterious List)
    print "\t AtomicArray A", A
    print "\t AtomicMap   M", M
    A[1] = "A"
    print "\t AtomicArray A", A

    val L = new ArrayList()
    L.add("a"); L.add("b")
    L.set(0, "A")
    print "\t ArrayList   L", L
}
function sort() {
    print "   .Sort."
    val S = new AtomicMap()
    val T = new AtomicMap()
    S[2] = "B"; S[4] = "A"
    print "\t S", S, "T", T
    print "\tasort :", asort(S, T)
    print "\t S", S, "T", T
    print "\tasorti:", asorti(S, T) # index sort.
    print "\t S", S, "T", T
    print "\tasorti:", asorti(S)
    print "\t S", S, "T", T
}
function mutable() {
    print "   .Mutable."
    # ミュータブルオブジェクト代入による、思いがけない副作用を防ぐため、次のように展開されます.
    # Expands to prevent unexpected side effects of mutable object assignment:
    # var C = D = 0 ->
    # var C = new AtomicNumber(0); var D = new AtomicNumber(0) or
    # var D = new AtomicNumber(0); var C = new AtomicNumber(C)
    #
    val A = B = 0   # Integer
    var C = D = 0   # AtomicNuber
    print "\t.'A,B,C,D'", A.getClass(), B.getClass(), C.getClass(), D.getClass()
    print "\t.A == B \t", A==B
    assertEquals(A, B, "A==B")
    print "\t.A === B\t", A===B, "Equivalent operation."
    assertTrue(A===B, "A===B")

    print "\t.A == C \t", A==C
    assertTrue(A==C, "A==C")
    print "\t.A !== C\t", A!==C, "Equivalent operation."
    assertTrue(A!==C, "A!==C")

    print "\t.C == D \t", C==D
    assertTrue(C==D, "C==D")
    print "\t.D === D\t", D===D, "Equivalent operation."
    assertTrue(D===D, "D===D")

    # ミュータブルオブジェクトの複製を作成し、等価演算子('===')を犠牲にしました.
    # I made a duplicate of a mutable object and sacrificed the equality operator ('===').
    print "\t.C === D\t", C===D
    assertTrue(C===D, "C===D", "'It cannot be used.'")
}