/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus

import groovy.transform.CompileStatic
import plus.lex.Parser

/**
 * AWK~plus Compiler.
 *
 * @author kunio himei.
 */
@CompileStatic
class Gen {

    static String USAGE = 'AWK~Plus generator [Script]'

    //* Import file name.
    private static final String IMPORT = 'lib/import.awk'

    //* per-define Script file name.
    private static final String PREDEF = 'lib/predefG.awk'

    static String[] makeArgs(String[] arr) {
        List<String> list = []
        list.add(IMPORT)
        list.add(PREDEF)
        for (x in arr)
            list.add(x)
        return list.toArray() as String[]
    }

    // main
    static void main(String[] args) {
        if (0 == args.length) {
            System.out.println USAGE
        } else {
            Parser.SyntaxTree sTree = new Parser().parse(makeArgs(args))
            new plus.gen.Gen(sTree).generate()
        }
    }
}