/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.csv.valueobject.BlancoCsvFieldStructureDotNet;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;
import blanco.valueobject.BlancoValueObjectDotNetXml2CsClass;
import blanco.valueobject.concretesax.BlancoValueObjectDotNetSerializer;

public class BlancoCsvExpandRecordDotNet {
    /**
     * R[hWJ܂B
     * 
     * @param processStructure
     * @param direcotryValueObjectWork
     * @param directoryTarget
     * @throws IOException
     * @throws TransformerException
     */
    public static void expand(final BlancoCsvStructureDotNet processStructure,
            final File direcotryValueObjectWork, final File directoryTarget)
            throws IOException, TransformerException {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + "CsvRecord";
        final String packageName = processStructure.getPackageName()
                + ".record";
        final File filePojoWork = new File(direcotryValueObjectWork
                .getAbsolutePath()
                + "/" + className + ".xml");

        OutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    filePojoWork));
            final BlancoValueObjectDotNetSerializer serializer = new BlancoValueObjectDotNetSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementWorkbook();
            serializer.characters("\n");
            serializer.startElementSheet("ValueObject");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectdotnetCommon();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementName();
            // O
            serializer.characters(className);
            serializer.endElementName();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementPackage();
            serializer.characters(packageName);
            serializer.endElementPackage();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementDescription();
            serializer.characters("blancoCsvDotNett@C`쐬ꂽR[hNX");
            serializer.endElementDescription();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementFileDescription();
            serializer.characters("t@C`["
                    + processStructure.getFileDefinitionId()
                    + (processStructure.getFileDescription() == null ? "" : "/"
                            + processStructure.getFileDescription())
                    + "]̃R[hNX\n");
            serializer.endElementFileDescription();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementBlancovalueobjectdotnetCommon();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectdotnetList();
            serializer.characters("\n");

            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet field = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                try {
                    boolean isQuoted = false;
                    String actualType = field.getType();
                    if (field.getType().endsWith("(quote)")) {
                        // NI[gw肪ꍇɂ́A^̂(quote)܂B
                        actualType = field.getType().substring(0,
                                field.getType().length() - "(quote)".length());
                        isQuoted = true;
                    }

                    serializer.characters("    ");
                    serializer.startElementField();
                    serializer.characters("\n");
                    serializer.characters("      ");

                    if (field.getNo() != null) {
                        serializer.startElementNo();
                        serializer.characters(field.getNo());
                        serializer.endElementNo();
                    }

                    serializer.characters("\n");
                    serializer.characters("      ");
                    serializer.startElementName();
                    serializer.characters(field.getName());
                    serializer.endElementName();
                    serializer.characters("\n");
                    serializer.characters("      ");
                    serializer.startElementType();
                    serializer.characters(actualType);
                    serializer.endElementType();
                    serializer.characters("\n");

                    serializer.characters("      ");
                    serializer.startElementDescription();
                    if (field.getNo() != null) {
                        serializer.characters("ڔԍ: " + field.getNo() + "\n");
                    }
                    if (field.getDescription() != null) {
                        serializer.characters("ڂ̐: "
                                + field.getDescription() + "\n");
                    }
                    if (isQuoted) {
                        serializer.characters("̓_uNI[gēo͂܂B\n");
                    }

                    if (field.getMinLength() != null) {
                        serializer.characters("MIN: " + field.getMinLength()
                                + "\n");
                    }
                    if (field.getMaxLength() != null) {
                        serializer.characters("MAX: " + field.getMaxLength()
                                + "\n");
                    }
                    serializer.endElementDescription();
                    serializer.characters("\n");

                    if (field.getDefault() != null) {
                        serializer.characters("      ");
                        serializer.startElementDefault();
                        serializer.characters(field.getDefault());
                        serializer.endElementDefault();
                        serializer.characters("\n");
                    }

                    serializer.characters("    ");
                    serializer.endElementField();
                    serializer.characters("\n");
                } catch (SAXException e) {
                    e.printStackTrace();
                }
            }

            serializer.characters("  ");
            serializer.endElementBlancovalueobjectdotnetList();
            serializer.characters("\n");
            serializer.endElementSheet();
            serializer.characters("\n");
            serializer.endElementWorkbook();
            serializer.endDocument();

            outStream.flush();
            outStream.close();
            outStream = null;

            new BlancoValueObjectDotNetXml2CsClass().process(filePojoWork,
                    directoryTarget);
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
