/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.csv.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.csv.BlancoCsvDotNetConstants;
import blanco.csv.BlancoCsvDotNetMeta2Xml;
import blanco.csv.BlancoCsvXml2CsClass;

/**
 * BlancoCsvAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoCsvDotNetTask extends AbstractBlancoCsvDotNetTask {

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoCsvTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpDirectory = new File(getTmpdir()
                    + BlancoCsvDotNetConstants.TARGET_DIRECTORY);
            blancoTmpDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            new BlancoCsvDotNetMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoCsvDotNetConstants.TARGET_DIRECTORY);

            final File tempValueObjectFolder = new File(getTmpdir()
                    + BlancoCsvDotNetConstants.TARGET_DIRECTORY
                    + BlancoCsvDotNetConstants.VALUE_OBJECT_DIRECTORY);
            tempValueObjectFolder.mkdirs();

            final File[] fileTmp = blancoTmpDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoCsvXml2CsClass().process(fileTmp[index],
                            getRuntimepackage(), tempValueObjectFolder,
                            new File(getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
