/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.db.BlancoDbMeta2Xml;
import blanco.db.BlancoDbTableMeta2Xml;
import blanco.db.BlancoDbXml2JavaClass;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * blancoDb Enterprise EditionAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoDbTask extends AbstractBlancoDbTask {
    /**
     * \[XohANZTIuWFNgL܂B
     */
    private final BlancoDbResourceBundle bundle = new BlancoDbResourceBundle();

    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpDbTableDirectory = new File(getTmpdir()
                    + "/db/table");
            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + "/db/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbDatabaseConnectionSettingDef connDef = new BlancoDbDatabaseConnectionSettingDef();
            connDef.setJdbcDriver(getJdbcdriver());
            connDef.setJdbcUrl(getJdbcurl());
            connDef.setJdbcUser(getJdbcuser());
            connDef.setJdbcPassword(getJdbcpassword());

            if (getSchema() != null) {
                // XL[}wB
                connDef.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // SimpleTableGateway
                final BlancoDbTableMeta2Xml gateway2xml = new BlancoDbTableMeta2Xml() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                gateway2xml.process(connDef, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbTableDirectory,
                        getBasepackage(), getRuntimepackage(), getTargetdir());
            }

            if (getSql() == null || getSql().equals("true")) {
                final File fileMetadir = new File(getMetadir());
                if (fileMetadir.exists() == false) {
                    throw new IllegalArgumentException("^fBNg["
                            + getMetadir() + "]݂܂B");
                }

                new BlancoDbMeta2Xml().processDirectory(fileMetadir,
                        blancoTmpDbSqlDirectory.getAbsolutePath());

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbSqlDirectory,
                        getBasepackage(), getRuntimepackage(), getTargetdir());
            }
        } catch (SQLException e) {
            throw new IllegalArgumentException(bundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(bundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr006()
                    + e.toString());
        }
    }
}
