/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtChapterStructure;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtStructure;

/**
 * u\[XeLXgvuHTMLt@Cvɕϊ܂B
 * 
 * ̑OɁASrcTxtւ̃C|[gWJ͏IĂKv肻łB
 */
public class BlancoTextConverterSrcTxt2Html {
    public void convert(final BufferedReader argReader,
            final BufferedWriter argWriter) throws IOException {
        final BlancoTextConverterSrcTxtStructure structure = parse(argReader);

        // ɏ݁I
        structure2File(structure, argWriter);
    }

    private BlancoTextConverterSrcTxtStructure parse(
            final BufferedReader argReader) throws IOException {
        final BlancoTextConverterSrcTxtStructure structure = new BlancoTextConverterSrcTxtStructure();

        boolean isBodyStarted = false;

        final StringBuffer strbuf = new StringBuffer();
        for (;;) {
            final String line = argReader.readLine();
            if (line == null) {
                break;
            }

            if (isBodyStarted == false) {
                // s̊Jn̏ꍇɂ̂ݔf܂B
                //  : ̐擪󔒂͖悤ɕύXB
                if (line.startsWith("Subject:")) {
                    structure.setSubject(line.substring("Subject:".length())
                            .trim());
                } else if (line.startsWith("Description:")) {
                    structure.setDescription(line.substring(
                            "Description:".length()).trim());
                } else if (line.startsWith("Keywords:")) {
                    structure.setKeywords(line.substring("Keywords:".length())
                            .trim());
                } else if (line.startsWith("Date:")) {
                    try {
                        // final SimpleDateFormat sdFormat = new
                        // SimpleDateFormat(
                        // "yyyy-MM-dd");
                        final SimpleDateFormat sdFormat = new SimpleDateFormat(
                                "yyyy-MM-dd HH:mm:ss");
                        structure.setDate(sdFormat.parse(line.substring(
                                "Date:".length()).trim()));
                    } catch (ParseException e) {
                        try {
                            final SimpleDateFormat sdFormat = new SimpleDateFormat(
                                    "yyyy-MM-dd");
                            structure.setDate(sdFormat.parse(line.substring(
                                    "Date:".length()).trim()));
                        } catch (ParseException e1) {
                            // ͂△Ă܂܂B
                            e1.printStackTrace();
                        }

                    }
                } else if (line.trim().length() == 0) {
                    // {fB̈̊JnB
                    isBodyStarted = true;
                } else {
                    //  Ă͂Ȃ܂B
                    System.out.println("p[XɎs[" + line + "]B܂B");
                }
            } else {
                // {fB̈łB
                // \̉͂Ȃ܂B

                // TODO ܂ [[]]̉͂Ȃ܂BdvB

                if (line.length() > 1 && line.charAt(0) != ' ') {
                    // 1ڂ當΃^CgB
                    writeChapter(line, 0, strbuf, structure);
                } else if (line.length() > 2 && line.charAt(0) == ' '
                        && line.charAt(1) != ' ') {
                    writeChapter(line, 1, strbuf, structure);
                } else if (line.length() > 3 && line.charAt(0) == ' '
                        && line.charAt(1) == ' ' && line.charAt(2) != ' ') {
                    writeChapter(line, 2, strbuf, structure);
                } else if (line.length() > 4 && line.charAt(0) == ' '
                        && line.charAt(1) == ' ' && line.charAt(2) == ' '
                        && line.charAt(3) != ' ') {
                    writeChapter(line, 3, strbuf, structure);
                } else {
                    if (line.trim().length() == 0) {
                        // słB
                        flushStringLine(strbuf, structure);
                    } else {
                        // ʏ̍słB

                        if (strbuf.length() > 0) {
                            strbuf.append("<BR>\n");
                        }

                        if (line.startsWith("    ") == false) {
                            throw new IllegalArgumentException("͖[" + line
                                    + "]");
                        }

                        // ̎_ŃGR[hĂi[܂B
                        strbuf.append(BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc(line.substring(4)));
                    }
                }
            }
        }

        flushStringLine(strbuf, structure);

        return structure;
    }

    private void writeChapter(final String line, final int level,
            final StringBuffer strbuf,
            final BlancoTextConverterSrcTxtStructure structure) {
        flushStringLine(strbuf, structure);

        String lineActual = line.substring(level);
        if (lineActual.startsWith("") || lineActual.startsWith("")
                || lineActual.startsWith("") || lineActual.startsWith("")) {
            lineActual = lineActual.substring(1);
        }

        final BlancoTextConverterSrcTxtChapterStructure chapter = new BlancoTextConverterSrcTxtChapterStructure();
        chapter.setLevel(level);
        chapter.setLine(lineActual);
        structure.getLineList().add(chapter);
    }

    private void flushStringLine(final StringBuffer strbuf,
            final BlancoTextConverterSrcTxtStructure structure) {
        if (strbuf.length() > 0) {
            structure.getLineList().add(strbuf.toString());
            strbuf.setLength(0);
        }
    }

    private void structure2File(
            final BlancoTextConverterSrcTxtStructure argStructure,
            final BufferedWriter argWriter) throws IOException {
        argWriter
                .write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        argWriter.newLine();

        argWriter.write("<HTML lang=\"ja\">");
        argWriter.newLine();

        argWriter.write("<HEAD>");
        argWriter.newLine();

        argWriter.write("<TITLE>");
        // TODO HTML̃GXP[vB
        argWriter.write(argStructure.getSubject());
        argWriter.write("</TITLE>");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("<META name=\"DESCRIPTION\" content=\""
                + argStructure.getDescription() + "\">");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("<META name=\"KEYWORDS\" content=\""
                + argStructure.getKeywords() + "\">");
        argWriter.newLine();

        if (argStructure.getDate() != null) {
            final SimpleDateFormat sdFormat1 = new SimpleDateFormat(
                    "yyyy-MM-dd");
            final SimpleDateFormat sdFormat2 = new SimpleDateFormat(
                    "HH:mm:ss+09:00");

            final StringBuffer strDate = new StringBuffer();
            strDate.append(sdFormat1.format(argStructure.getDate()));

            if (sdFormat2.format(argStructure.getDate()).equals(
                    "00:00:00+09:00")) {
                // 00:00:00o͂}܂B
            } else {
                strDate.append("T" + sdFormat2.format(argStructure.getDate()));
            }

            argWriter.write("<META name=\"DATE\" content=\"" + strDate + "\">");
            argWriter.newLine();
        }

        argWriter.write("<META name=\"GENERATOR\" content=\""
                + BlancoTextConverterConstants.PRODUCT_NAME + " ("
                + BlancoTextConverterConstants.VERSION + ")\">");
        argWriter.newLine();

        // TODO R[hǂ̂H
        argWriter
                .write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">");
        argWriter.newLine();

        argWriter
                .write("<META http-equiv=\"Content-Style-Type\" content=\"text/css\">");
        argWriter.newLine();

        argWriter.write("</HEAD>");
        argWriter.newLine();

        argWriter.write("<BODY bgcolor=\"#eeddcc\">");
        argWriter.newLine();

        for (int index = 0; index < argStructure.getLineList().size(); index++) {
            final Object objLine = argStructure.getLineList().get(index);
            if (objLine instanceof BlancoTextConverterSrcTxtChapterStructure) {
                final BlancoTextConverterSrcTxtChapterStructure chapter = (BlancoTextConverterSrcTxtChapterStructure) objLine;
                if (chapter.getLevel() == 0) {
                    argWriter.newLine();
                    argWriter.write("<TABLE summary=\"mini title\">");
                    argWriter.newLine();
                    argWriter.write("<TBODY>");
                    argWriter.newLine();
                    argWriter.write("  <TR>");
                    argWriter.newLine();
                    argWriter
                            .write("    <TD bgcolor=\"#ff9900\" valign=\"top\"><FONT color=\"#ffffff\" size=\"+1\"><STRONG>"
                                    + BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(chapter
                                                    .getLine())
                                    + "</STRONG></FONT></TD>");
                    argWriter.newLine();
                    argWriter.write("  </TR>");
                    argWriter.newLine();
                    argWriter.write("</TBODY>");
                    argWriter.newLine();
                    argWriter.write("</TABLE>");
                    argWriter.newLine();
                } else {
                    argWriter.write("<STRONG>"
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(chapter.getLine())
                            + "</STRONG>");
                    argWriter.newLine();
                }
            } else {
                final String line = (String) objLine;
                // ʂ̍sB
                // TODO HTML̃GXP[vB
                argWriter.write("<P>");

                StringTokenizer token = new StringTokenizer(line, "\n");
                for (boolean isFirst = true; token.hasMoreTokens(); isFirst = false) {
                    if (isFirst == false) {
                        argWriter.newLine();
                    }
                    argWriter.write(token.nextToken());
                }

                argWriter.write("</P>");
                argWriter.newLine();
            }
        }

        argWriter.write("<HR>");
        argWriter.newLine();
        argWriter.write("<ADDRESS>");
        argWriter.newLine();

        if (argStructure.getDate() != null) {
            final SimpleDateFormat sdFormat1 = new SimpleDateFormat(
                    "yyyy/MM/dd");
            final SimpleDateFormat sdFormat2 = new SimpleDateFormat("HH:mm:ss");
            final StringBuffer strDate = new StringBuffer();
            strDate.append(sdFormat1.format(argStructure.getDate()));
            if (sdFormat2.format(argStructure.getDate()).equals("00:00:00") == false) {
                strDate.append(" " + sdFormat2.format(argStructure.getDate()));
            }
            argWriter
                    .write("<A href=\"memo/memoigapyon.html\">҂ɂ</A><BR>  Last modified: $Date: "
                            + strDate + " $");
        }

        argWriter.write("</ADDRESS>");
        argWriter.newLine();

        argWriter.write("</BODY>");
        argWriter.newLine();

        argWriter.write("</HTML>");
        argWriter.newLine();
    }
}
