/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder;

import bodybuilder.builder.BuilderMapping;
import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.argument.ArgumentBuilder;
import bodybuilder.builder.value.ExtendedValue;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.jdom.JDOMUtils;
import org.jdom.Element;

public abstract class Builder {
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_TYPE = "type";
    protected static final String ELEM_CONSTRUCTOR = "constructor";
    protected boolean hasConstructor = true;
    protected boolean hasChild = true;

    protected abstract Object getMuscle(Element var1, Argument var2);

    public static Object getValue(Element element) {
        return Builder.getValue(element, null);
    }

    public static Object getValue(Element element, String type) {
        try {
            String valueStr = element.getAttributeValue(ATTR_VALUE);
            if (valueStr == null) {
                Element child = JDOMUtils.getRequiredChild(element);
                return Builder.build(child);
            }
            if (ExtendedValue.isExtended(valueStr)) {
                return ExtendedValue.getValue(valueStr);
            }
            valueStr = ExtendedValue.unescapeExtendedValue(valueStr);
            if (type == null) {
                type = Builder.getType(element);
            }
            Object value = ObjectUtils.getObject(valueStr, type);
            return value;
        }
        catch (BodyBuilderException e) {
            e.setElement(element);
            throw e;
        }
        catch (Exception e) {
            throw new BodyBuilderException("build failed by '" + element.getName() + "' element.", e, element);
        }
    }

    public static Object build(Element element) {
        try {
            Builder builder = Builder.getBuilder(element.getName());
            Argument constructor = Builder.getConstructor(element, builder.hasConstructor);
            if (!builder.hasChild && element.getChildren().size() > 0) {
                throw new BodyBuilderException("cannot define child '" + element.getName() + "'.");
            }
            return builder.getMuscle(element, constructor);
        }
        catch (BodyBuilderException e) {
            e.setElement(element);
            throw e;
        }
        catch (Exception e) {
            throw new BodyBuilderException("build failed by '" + element.getName() + "' element.", e, element);
        }
    }

    private static Builder getBuilder(String name) {
        Builder builder = BuilderMapping.getBuilder(name);
        if (builder == null) {
            throw new BodyBuilderException("cannot find builder '" + name + "'.");
        }
        return builder;
    }

    private static Argument getConstructor(Element element, boolean hasConstructor) {
        Argument argument = null;
        Element constructor = element.getChild(ELEM_CONSTRUCTOR);
        if (constructor != null) {
            if (!hasConstructor) {
                throw new BodyBuilderException("cannot pass constructor '" + element.getName() + "'.");
            }
            argument = ArgumentBuilder.getArgument(constructor);
            element.removeChild(ELEM_CONSTRUCTOR);
        }
        return argument;
    }

    protected static Object newObject(String type, Argument constructor) {
        if (constructor != null) {
            return ObjectUtils.getInstance(type, constructor.getClasses(), constructor.getArguments());
        }
        return ObjectUtils.getObject(type);
    }

    protected static Object newObject(Class type, Argument constructor) {
        if (constructor != null) {
            return ObjectUtils.getInstance(type, constructor.getClasses(), constructor.getArguments());
        }
        return ObjectUtils.getObject(type);
    }

    protected static String getRequiredName(Element element) {
        return JDOMUtils.getRequiredAttrValue(element, ATTR_NAME);
    }

    protected static String getValueAttr(Element element) {
        return element.getAttributeValue(ATTR_VALUE);
    }

    protected static String getRequiredValueAttr(Element element) {
        return JDOMUtils.getRequiredAttrValue(element, ATTR_VALUE);
    }

    protected static String getType(Element element) {
        String type = element.getAttributeValue(ATTR_TYPE);
        return type != null ? type.trim() : type;
    }

    protected static String getType(Element element, String defaultType) {
        String type = JDOMUtils.getAttrValue(element, ATTR_TYPE, defaultType);
        return type != null ? type.trim() : type;
    }

    protected static String getRequiredType(Element element) {
        String type = JDOMUtils.getRequiredAttrValue(element, ATTR_TYPE);
        return type != null ? type.trim() : type;
    }
}

