/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.usually;

import bodybuilder.test.TestCaseXML;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.common.Target;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.util.jdom.JDOMUtils;
import org.jdom.Element;

public class UsualTestCaseXML
extends TestCaseXML {
    protected Target target = null;
    protected Execute execute = null;
    protected DatabaseSetUp databaseSetUp = null;
    protected Return ret = null;
    protected Catch catch_ = null;
    protected DatabaseAssertion databaseAssertion = null;

    protected void build() {
        super.build();
        this.loadTarget(this.root);
        Element input = JDOMUtils.getRequiredChild(this.root, "input");
        this.loadInput(input);
        Element expected = JDOMUtils.getRequiredChild(this.root, "expected");
        this.loadExpect(expected);
    }

    protected void loadTarget(Element root) {
        Element target = JDOMUtils.getRequiredChild(root, "target");
        this.target = new Target(target);
    }

    private void loadInput(Element input) {
        Element execElem = JDOMUtils.getRequiredChild(input, "execute");
        this.execute = new Execute(execElem);
        Element databaseElem = input.getChild("database");
        if (databaseElem != null) {
            this.databaseSetUp = new DatabaseSetUp(databaseElem, this.file.getParent());
        }
    }

    protected void loadExpect(Element expected) {
        Element databaseElem;
        Element catchElem;
        Element retElem = expected.getChild("return");
        if (retElem != null) {
            this.ret = new Return(retElem);
        }
        if ((catchElem = expected.getChild("catch")) != null) {
            this.catch_ = new Catch(catchElem);
        }
        if ((databaseElem = expected.getChild("database")) != null) {
            this.databaseAssertion = new DatabaseAssertion(databaseElem, this.file.getParent());
        }
    }

    public Target getTarget() {
        return this.target;
    }

    public Execute getExecute() {
        return this.execute;
    }

    public DatabaseSetUp getDatabaseSetUp() {
        return this.databaseSetUp;
    }

    public Return getReturn() {
        return this.ret;
    }

    public Catch getCatch() {
        return this.catch_;
    }

    public DatabaseAssertion getDatabaseAssertion() {
        return this.databaseAssertion;
    }
}

