package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.servlet.ServletObjectsBullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample06 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample06.xml");
        // ブルワーカを生成。
        ServletObjectsBullworker bullworker = new ServletObjectsBullworker(in);
        SampleUtils.closeInputStream(in);

        // サーブレットコンテキスト
        Object servletcontext = bullworker.getServletContext();
        Viewer.dump(servletcontext);

        // リクエスト
        Object request = bullworker.getRequest();
        Viewer.dump(request);

        // セッション
        Object session = bullworker.getSession();
        Viewer.dump(session);
    }

}