package sample.testtarget.usually;

import java.io.IOException;

/**
 * エラーを起こすオブジェクト
 */
public class ErrorTarget {

    /**
     * 入出力例外を投げる。
     * 
     * @throws IOException 入出力エラーの場合
     */
    public void ioerror() throws IOException {
        // 例外を投げる。
        throw new IOException("入出力例外です。");
    }

    /**
     * 入出力例外を投げる。(正規表現っぽいエラーメッセージを投げる場合)
     * 
     * @throws IOException 入出力エラーの場合
     */
    public void ioerrorWithMessageLikeRegex() throws IOException {
        // 例外を投げる。
        throw new IOException("/[0-9]+/");
    }

}