package bodybuilder.ant.xmltest;

import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;

import bodybuilder.test.XMLTestRunner;
import bodybuilder.util.FileUtils;

/**
 * 拡張XMLJUnitフォーマッタ
 */
public class ExtendedXMLJUnitResultFormatter extends XMLJUnitResultFormatter {

    /**
     * テストスイートを開始する。
     * 
     * @param suite テストスイート
     */
    public void startTestSuite(JUnitTest suite) {
        // テストケースディレクトリを取得。
        String dirs = System.getProperty(XMLJUnitTask.TEST_PROP_KEY_ROOT_DIRS);

        if (dirs.indexOf(",") < 0) {
            // ディレクトリが１つの場合はディレクトリ名をテスト名にセット。
            suite.setName(FileUtils.toDotSeparatedValue(dirs));
        } else {
            // ディレクトリが複数の場合はXMLテストランナーのクラス名をテスト名にセット。
            suite.setName(XMLTestRunner.class.getName());
        }

        // テストスイートを開始。
        super.startTestSuite(suite);
    }

}