package bodybuilder.ant.xmltest;

import java.io.File;
import java.io.IOException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

import bodybuilder.test.XMLTestRunner;
import bodybuilder.util.FileUtils;

/**
 * XMLテスト要素
 */
public class XMLJUnitTest extends JUnitTest {

    /**
     * コンストラクタ。
     */
    public XMLJUnitTest() {
        // XMLテストケースのクラス名をテスト名にセット。
        super(XMLTestRunner.class.getName());
    }

    /////////////////////////////////////////////////////////////////
    // name attribute

    /**
     * テスト名フラグ
     */
    private boolean named = false;

    /**
     * テスト名がセットされているかを取得する。
     * 
     * @return テスト名がセットされている場合はtrue
     */
    public boolean isNamed() {
        return named;
    }

    /**
     * テスト名をセットする。
     * 
     * @param value テスト名
     */
    public void setName(String value) {
        // フラグをtrueにする。
        named = true;
        // テスト名をセット。
        super.setName(value);
    }

    /////////////////////////////////////////////////////////////////
    // fork attribute

    /**
     * フォークフラグをセットする。
     * 
     * @param value フォークフラグ
     */
    public void setFork(boolean value) {
        // テストごとにフォークフラグをセットできないようにする。
        throw new BuildException(
                "The <xmltest> type doesn't support the \"fork\" attribute.");
    }

    /**
     * フォークフラグをセットする。
     * 
     * @param value フォークフラグ
     */
    void setFork2(boolean value) {
        super.setFork(value);
    }

    /////////////////////////////////////////////////////////////////
    // path attribute

    /**
     * パス
     */
    private String path = null;

    /**
     * パスをセットする。
     * 
     * @param path パス
     */
    public void setPath(String path) {
        File pathelem = new File(path);

        // ファイルが存在しない場合はエラー。
        if (!pathelem.exists()) {
            throw new BuildException("could not find path \"" + path + "\".");
        }

        // 絶対パスに変換。
        try {
            path = pathelem.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException("could not get canonical path \"" + path
                    + "\".", e);
        }

        // ドライブレターを削除。
        path = FileUtils.removeDriveLetter(path);
        // 出力ファイル名をセット。
        String outfile = "TEST-" + FileUtils.toDotSeparatedValue(path);
        setOutfile(outfile);
        // フィールドにセット。
        this.path = path;
    }

    /**
     * パスを取得する。
     * 
     * @return パス
     */
    public String getPath() {
        return path;
    }

}