package bodybuilder.test;

import junit.framework.Test;

import org.jdom.Element;

import bodybuilder.util.FileUtils;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * 抽象テストケースXML
 */
public abstract class TestCaseXML extends XML {

    /**
     * テスト名
     */
    protected String name = null;

    /**
     * テストの説明
     */
    protected String description = "";

    /**
     * テストを取得する。
     */
    public Test getTest() {
        // XMLにマップされたテストを返す。
        XMLTestCase test = TestCaseMapping.getTestCase(xmlType);
        test.setName(name);
        test.setXML(this);
        return test;
    }

    /////////////////////////////////////////////////////////////////
    // build method

    /**
     * テストケースXMLを構築する。
     */
    protected void build() {
        StringBuffer buf = new StringBuffer();

        // バッファにファイル名を追加。
        buf.append("[");
        buf.append(FileUtils.removeExt(file.getName()));
        buf.append("]");

        // XMLからテスト名を取得。
        String nameInXml = root.getChildTextTrim("name");

        // XMLのテスト名がnullで無ければバッファに追加。
        if (nameInXml != null) {
            buf.append(" ");
            buf.append(nameInXml.replace('(', '（').replace(')', '）'));
        }

        // テスト名を設定。
        name = buf.toString();

        // テスト名の括弧を変換。
        name = name.replace('(', '（').replace(')', '）');

        // テストの説明を取得。
        Element description = root.getChild("description");

        if (description != null) {
            this.description = description.getText();
        }

        // トリムフラグがtrueの場合はテストの説明をトリム。
        if (JDOMUtils.getAttrBoolValue(description, "trim")) {
            this.description = this.description.trim();
        }
    }

    /////////////////////////////////////////////////////////////////
    // property

    /**
     * テスト名を取得する。
     * 
     * @return テスト名
     */
    public String getName() {
        return name;
    }

    /**
     * テストの説明を取得する。
     * 
     * @return テストの説明
     */
    public String getDescription() {
        return description;
    }

}