package bodybuilder.test.jsp;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.TestCaseXML;

/**
 * JSPテストケース
 */
public class JSPTestCase extends XMLTestCase {

    /**
     * テストケースXMLのパラメータ名
     */
    public static final String TESTCASE_XML_PARAM_NAME = "_"
            + JSPTestCase.class.getName() + "_testcase_xml";

    /**
     * JSPテストケースXML
     */
    protected JSPTestCaseXML xml = null;

    /**
     * 初期化フラグ
     */
    private static boolean initialize = false;

    /**
     * JSPテストケースXMLをセットする。
     * 
     * @param xml JSPテストケースXML
     */
    protected void setXML(TestCaseXML xml) {
        this.xml = (JSPTestCaseXML) xml;
    }

    /**
     * テストを実行する。
     */
    protected void runTest() {
        info("'" + getName() + "' is started .");
        debug("description is:" + Config.NL + xml.getDescription());

        // 初期化する。
        init();

        // コンテキストルートを取得。
        String contextRoot = Config.getContextRoot();
        debug("context root is '" + contextRoot + "'.");

        // パスを取得。
        String path = contextRoot + xml.getPath();
        debug("request path is '" + path + "'.");

        // リクエストの文字セットを取得。
        String charset = Config.getRequestCharset();
        debug("request charset is '" + charset + "'.");

        // TODO 文字化けに対応すること。
        HttpUnitOptions.setDefaultCharacterSet(charset);
        HttpUnitOptions.setPostIncludesCharset(true);

        WebConversation wc = new WebConversation();

        // POSTリクエストを生成。
        String redirector = contextRoot + Config.getRedirectorPath();
        debug("create post method for redirector '" + redirector + "'.");
        WebRequest req = new PostMethodWebRequest(redirector);

        // パラメータをセット。
        debug("setup request parameters.");
        Map params = xml.getParama();
        Iterator names = params.keySet().iterator();

        while (names.hasNext()) {
            String name = (String) names.next();
            String[] values = (String[]) params.get(name);

            if (values.length == 1) {
                debug("add patameter '" + name + "'(" + values[0] + ").");
            } else {
                debug("add patameter '" + name + "'(" + Arrays.asList(values)
                        + ").");
            }

            req.setParameter(name, values);
        }

        // パラメータにテストケースXMLをセット。
        debug("set testcase xml to patameter");
        req.setParameter(TESTCASE_XML_PARAM_NAME, xml.getFile()
                .getAbsolutePath());

        // リクエストを投げる。
        debug("request to '" + redirector + "'.");
        WebResponse res = null;

        try {
            res = wc.getResponse(req);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BodyBuilderException("it was not able to request '"
                    + redirector + "'.", e);
        }

        // 出力先を取得。
        String output = xml.getOutput();
        debug("output is '" + output + "'.");
        String resText = null;

        try {
            resText = res.getText();
        } catch (IOException e) {
            throw new BodyBuilderException("could not get response text.", e);
        }

        debug("response text is:" + Config.NL + resText);

        // ファイルを出力。
        debug("output file.");

        try {
            FileWriter writer = new FileWriter(output);
            writer.write(resText);
            writer.flush();
            writer.close();
        } catch (IOException e) {
            throw new BodyBuilderException("could not output file.", e);
        }

        info("test was ended.");
    }

    /**
     * 初期化する。
     */
    private void init() {
        // 既に初期化されている場合は何もしない。
        if (initialize) {
            return;
        }

        // 初期化パスを取得。
        String path = Config.getInitRequestPath();
        debug("init request path is '" + path + "'.");

        // 初期化パスがnullの場合は何もしない。
        if (path == null) {
            return;
        }

        // 初期化する。
        debug("initialize request.");

        WebConversation wc = new WebConversation();
        WebRequest req = new GetMethodWebRequest(path);

        // リクエストを投げる。
        try {
            wc.getResponse(req);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BodyBuilderException(
                    "it was not able to initialize request '" + path + "'.", e);
        }
    }

}