package bodybuilder.viewer;

import java.lang.reflect.Array;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * 配列ビューア
 */
public class ArrayViewer extends Viewer {

    /**
     * 配列の内容を出力する。
     * 
     * @param object 配列
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // 配列の長さを取得。
        int len = Array.getLength(object);
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // 配列の要素を出力。
        for (int i = 0; i < len; i++) {
            handler.print("[" + i + "]=>");
            dump(Array.get(object, i), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}