package bodybuilder.viewer;

import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;
import bodybuilder.viewer.handler.StandardOutputHandler;

/**
 * ビューア
 */
public abstract class Viewer {

    /////////////////////////////////////////////////////////////////
    // abstract method

    /**
     * オブジェクトの内容を出力する。
     * 
     * @param object オブジェクト
     * @param handler 出力ハンドラ
     */
    public abstract void output(Object object, OutputHandler handler);

    /////////////////////////////////////////////////////////////////
    // public method

    /**
     * オブジェクトの内容をダンプする。
     * 
     * @param object オブジェクト
     */
    public static void dump(Object object) {
        String handlerClassName = Config.getOutputHandler();
        OutputHandler handler = null;

        // ハンドラを生成。
        if (handlerClassName != null) {
            handler = (OutputHandler) ObjectUtils.getObject(handlerClassName);
        } else {
            // 未定義の場合は標準出力ハンドラ。
            handler = new StandardOutputHandler();
        }

        dump(object, handler);
    }

    /**
     * オブジェクトの内容をダンプする。
     * 
     * @param object オブジェクト
     * @param handler 出力ハンドラ
     */
    public static void dump(Object object, OutputHandler handler) {
        // オブジェクトにマップされたハンドラを出力。
        Viewer viewer = ViewerMapping.getViewer(object);

        // ハンドラがない場合は、オブジェクトの情報をそのまま出力。
        if (viewer == null) {
            handler.print(ObjectUtils.getInfo(object, true));
            return;
        }

        // オブジェクトの内容を出力。
        viewer.output(object, handler);
    }

}