/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.BufferByteArrayOutputStream;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPService
implements ReadWriteObserver {
    private static final Log LOG;
    private static final UDPService INSTANCE;
    private DatagramChannel _channel;
    private final List OUTGOING_MSGS;
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private volatile boolean _acceptedSolicitedIncoming = false;
    private volatile boolean _acceptedUnsolicitedIncoming = false;
    private long _lastUnsolicitedIncomingTime = 0L;
    private volatile long _lastReceivedAny = 0L;
    private long _lastConnectBackTime = System.currentTimeMillis();
    private boolean _portStable = true;
    private int _lastReportedPort;
    private int _numReceivedIPPongs;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());
    private final GUID SOLICITED_PING_GUID = new GUID(GUID.makeGuid());
    private boolean _started = false;
    private static final long PING_PERIOD = 85000L;
    private static final byte[] IN_HEADER_BUF;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.UDPService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new UDPService();
        IN_HEADER_BUF = new byte[23];
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - Acceptor.INCOMING_EXPIRE_TIME;
    }

    public static UDPService instance() {
        return INSTANCE;
    }

    protected UDPService() {
        this.OUTGOING_MSGS = new LinkedList();
        byte[] byArray = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(byArray);
        this.scheduleServices();
    }

    protected void scheduleServices() {
        RouterService.schedule(new IncomingValidator(), Acceptor.TIME_BETWEEN_VALIDATES, Acceptor.TIME_BETWEEN_VALIDATES);
        RouterService.schedule(new PeriodicPinger(), 0L, 85000L);
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public GUID getSolicitedGUID() {
        return this.SOLICITED_PING_GUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DatagramChannel datagramChannel;
        UDPService uDPService = this;
        synchronized (uDPService) {
            this._started = true;
            datagramChannel = this._channel;
        }
        if (datagramChannel != null) {
            NIODispatcher.instance().registerReadWrite(datagramChannel, this);
        }
    }

    DatagramSocket newListeningSocket(int n) throws IOException {
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            DatagramSocket datagramSocket = datagramChannel.socket();
            datagramSocket.setReceiveBufferSize(65536);
            datagramSocket.setSendBufferSize(65536);
            datagramSocket.bind(new InetSocketAddress(n));
            return datagramSocket;
        }
        catch (SecurityException securityException) {
            throw new IOException("security exception on port: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._channel != null) {
            try {
                this._channel.close();
            }
            catch (IOException iOException) {}
        }
        if (datagramSocket != null) {
            boolean bl;
            UDPService uDPService = this;
            synchronized (uDPService) {
                this._channel = datagramSocket.getChannel();
                if (this._channel == null) {
                    throw new IllegalArgumentException("No channel!");
                }
                bl = this._started;
                this._lastReportedPort = this._channel.socket().getLocalPort();
                this._portStable = true;
            }
            if (bl) {
                this.start();
            }
        }
    }

    public void shutdown() {
        this.setListeningSocket(null);
    }

    public void handleRead() throws IOException {
        while (true) {
            SocketAddress socketAddress;
            this.BUFFER.clear();
            try {
                socketAddress = this._channel.receive(this.BUFFER);
            }
            catch (IOException iOException) {
                break;
            }
            catch (Error error) {
                break;
            }
            if (socketAddress == null) break;
            if (!(socketAddress instanceof InetSocketAddress)) {
                Assert.silent(false, "non-inet SocketAddress: " + socketAddress);
                continue;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (!NetworkUtils.isValidAddress(inetSocketAddress.getAddress()) || !NetworkUtils.isValidPort(inetSocketAddress.getPort())) continue;
            byte[] byArray = this.BUFFER.array();
            int n = this.BUFFER.position();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                Message message = MessageFactory.read((InputStream)byteArrayInputStream, 2, IN_HEADER_BUF);
                if (message == null) continue;
                this.processMessage(message, inetSocketAddress);
            }
            catch (IOException iOException) {
            }
            catch (BadPacketException badPacketException) {}
        }
    }

    public void handleIOException(IOException iOException) {
        if (!(iOException instanceof ClosedChannelException)) {
            ErrorService.error(iOException, "UDP Error.");
        } else {
            LOG.trace((Object)"Swallowing a UDPService ClosedChannelException", (Throwable)iOException);
        }
    }

    protected void processMessage(Message message, InetSocketAddress inetSocketAddress) {
        this.updateState(message, inetSocketAddress);
        MessageDispatcher.instance().dispatchUDP(message, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(Message message, InetSocketAddress inetSocketAddress) {
        this._lastReceivedAny = System.currentTimeMillis();
        if (!this.isGUESSCapable()) {
            if (message instanceof PingRequest) {
                GUID gUID = new GUID(message.getGUID());
                if (this.isValidForIncoming(this.CONNECT_BACK_GUID, gUID, inetSocketAddress)) {
                    this._acceptedUnsolicitedIncoming = true;
                }
                this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
            } else if (message instanceof PingReply) {
                GUID gUID = new GUID(message.getGUID());
                if (!this.isValidForIncoming(this.SOLICITED_PING_GUID, gUID, inetSocketAddress)) {
                    return;
                }
                this._acceptedSolicitedIncoming = true;
                PingReply pingReply = (PingReply)message;
                if (pingReply.getMyPort() != 0) {
                    UDPService uDPService = this;
                    synchronized (uDPService) {
                        ++this._numReceivedIPPongs;
                        if (this._numReceivedIPPongs == 1) {
                            this._lastReportedPort = pingReply.getMyPort();
                        } else if (this._lastReportedPort != pingReply.getMyPort()) {
                            this._portStable = false;
                            this._lastReportedPort = pingReply.getMyPort();
                        }
                    }
                }
            }
        }
        if (message instanceof ReplyNumberVendorMessage) {
            this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
        }
    }

    private boolean isValidForIncoming(GUID gUID, GUID gUID2, InetSocketAddress inetSocketAddress) {
        if (!gUID.equals(gUID2)) {
            return false;
        }
        String string = inetSocketAddress.getAddress().getHostAddress();
        return !RouterService.getConnectionManager().isConnectedTo(string) && !NetworkUtils.isPrivateAddress(inetSocketAddress.getAddress());
    }

    public void send(Message message, InetSocketAddress inetSocketAddress) {
        this.send(message, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public void send(Message message, IpPort ipPort) {
        this.send(message, ipPort.getInetAddress(), ipPort.getPort());
    }

    public void send(Message message, InetAddress inetAddress, int n) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Invalid Port: " + n);
        }
        if (this._channel == null || this._channel.socket().isClosed()) {
            return;
        }
        int n2 = message.getTotalLength();
        ByteBuffer byteBuffer = NIODispatcher.instance().getBufferCache().getHeap(n2);
        if (byteBuffer.remaining() != n2) {
            throw new IllegalStateException("retrieved a buffer with wrong remaining! wanted: " + n2 + ", had: " + byteBuffer.remaining() + ", position: " + byteBuffer.position() + ", limit: " + byteBuffer.limit());
        }
        BufferByteArrayOutputStream bufferByteArrayOutputStream = new BufferByteArrayOutputStream(byteBuffer);
        try {
            message.writeQuickly(bufferByteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return;
        }
        byteBuffer.flip();
        this.send(byteBuffer, inetAddress, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer byteBuffer, InetAddress inetAddress, int n, boolean bl) {
        List list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(byteBuffer, inetAddress, n, bl));
            if (this._channel != null) {
                NIODispatcher.instance().interestWrite(this._channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleWrite() throws IOException {
        List list = this.OUTGOING_MSGS;
        synchronized (list) {
            while (true) {
                Object var5_5;
                if (this.OUTGOING_MSGS.isEmpty()) {
                    NIODispatcher.instance().interestWrite(this._channel, false);
                    return false;
                }
                boolean bl = true;
                SendBundle sendBundle = (SendBundle)this.OUTGOING_MSGS.remove(0);
                try {
                    try {
                        if (this._channel.send(sendBundle.buffer, sendBundle.addr) == 0) {
                            this.OUTGOING_MSGS.add(0, sendBundle);
                            return true;
                        }
                        if (sendBundle.custom) {
                            sendBundle.buffer.rewind();
                            bl = false;
                        }
                    }
                    catch (IOException iOException) {
                        LOG.warn((Object)"Ignoring exception on socket", (Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    if (!bl) throw throwable;
                    NIODispatcher.instance().getBufferCache().release(sendBundle.buffer);
                    throw throwable;
                }
                {
                    var5_5 = null;
                    if (!bl) continue;
                    NIODispatcher.instance().getBufferCache().release(sendBundle.buffer);
                    continue;
                }
                break;
            }
        }
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDoFWT() {
        if (!this.canReceiveSolicited()) {
            return false;
        }
        if (!RouterService.isConnected()) {
            return !ConnectionSettings.LAST_FWT_STATE.getValue();
        }
        boolean bl = true;
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._numReceivedIPPongs < 1) {
                return !ConnectionSettings.LAST_FWT_STATE.getValue();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("stable " + this._portStable + " last reported port " + this._lastReportedPort + " our external port " + RouterService.getPort() + " our non-forced port " + RouterService.getAcceptor().getPort(false) + " number of received IP pongs " + this._numReceivedIPPongs + " valid external addr " + NetworkUtils.isValidAddress(RouterService.getExternalAddress())));
            }
            boolean bl2 = bl = NetworkUtils.isValidAddress(RouterService.getExternalAddress()) && this._portStable;
            if (this._numReceivedIPPongs == 1) {
                bl = bl && (this._lastReportedPort == RouterService.getAcceptor().getPort(false) || this._lastReportedPort == RouterService.getPort());
            }
        }
        ConnectionSettings.LAST_FWT_STATE.setValue(!bl);
        return bl;
    }

    public boolean portStable() {
        return this._portStable;
    }

    public int receivedIpPong() {
        return this._numReceivedIPPongs;
    }

    public int lastReportedPort() {
        return this._lastReportedPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStableUDPPort() {
        int n = RouterService.getAcceptor().getPort(false);
        int n2 = RouterService.getPort();
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._portStable && this._numReceivedIPPongs > 1) {
                return this._lastReportedPort;
            }
            if (this._numReceivedIPPongs == 1 && (n == this._lastReportedPort || n2 == this._lastReportedPort)) {
                return this._lastReportedPort;
            }
        }
        return n2;
    }

    public void setReceiveSolicited(boolean bl) {
        this._acceptedSolicitedIncoming = bl;
    }

    public long getLastReceivedTime() {
        return this._lastReceivedAny;
    }

    public boolean isListening() {
        if (this._channel == null) {
            return false;
        }
        return this._channel.socket().getLocalPort() != -1;
    }

    public String toString() {
        return "UDPService::channel: " + this._channel;
    }

    static /* synthetic */ void access$4(UDPService uDPService, boolean bl) {
        uDPService._acceptedUnsolicitedIncoming = bl;
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;
        private final boolean custom;

        SendBundle(ByteBuffer byteBuffer, InetAddress inetAddress, int n, boolean bl) {
            this.buffer = byteBuffer;
            this.addr = new InetSocketAddress(inetAddress, n);
            this.custom = bl;
        }
    }

    private static class MLImpl
    implements MessageListener {
        public boolean _gotIncoming = false;

        private MLImpl() {
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            if (message instanceof PingRequest) {
                this._gotIncoming = true;
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            long l = System.currentTimeMillis();
            MessageRouter messageRouter = RouterService.getMessageRouter();
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            if (messageRouter == null || connectionManager == null) {
                return;
            }
            if (UDPService.this._acceptedUnsolicitedIncoming && l - UDPService.this._lastUnsolicitedIncomingTime > Acceptor.INCOMING_EXPIRE_TIME || !UDPService.this._acceptedUnsolicitedIncoming && l - UDPService.this._lastConnectBackTime > Acceptor.INCOMING_EXPIRE_TIME) {
                GUID gUID = new GUID(GUID.makeGuid());
                MLImpl mLImpl = new MLImpl();
                messageRouter.registerMessageListener(gUID.bytes(), mLImpl);
                if (connectionManager.sendUDPConnectBackRequests(gUID)) {
                    UDPService.this._lastConnectBackTime = System.currentTimeMillis();
                    Runnable runnable = new Runnable(this, l, mLImpl, messageRouter, gUID){
                        final /* synthetic */ IncomingValidator this$1;
                        private final /* synthetic */ long val$currTime;
                        private final /* synthetic */ MLImpl val$ml;
                        private final /* synthetic */ MessageRouter val$mr;
                        private final /* synthetic */ GUID val$cbGuid;
                        {
                            this.this$1 = incomingValidator;
                            this.val$currTime = l;
                            this.val$ml = mLImpl;
                            this.val$mr = messageRouter;
                            this.val$cbGuid = gUID;
                        }

                        public void run() {
                            if (UDPService.access$0(IncomingValidator.access$0(this.this$1)) && UDPService.access$1(IncomingValidator.access$0(this.this$1)) < this.val$currTime || !UDPService.access$0(IncomingValidator.access$0(this.this$1))) {
                                UDPService.access$4(IncomingValidator.access$0(this.this$1), this.val$ml._gotIncoming);
                            }
                            this.val$mr.unregisterMessageListener(this.val$cbGuid.bytes(), this.val$ml);
                        }
                    };
                    RouterService.schedule(runnable, Acceptor.WAIT_TIME_AFTER_REQUESTS, 0L);
                } else {
                    messageRouter.unregisterMessageListener(gUID.bytes(), mLImpl);
                }
            }
        }

        static /* synthetic */ UDPService access$0(IncomingValidator incomingValidator) {
            return incomingValidator.UDPService.this;
        }
    }

    private class PeriodicPinger
    implements Runnable {
        private PeriodicPinger() {
        }

        public void run() {
            GUESSEndpoint gUESSEndpoint = QueryUnicaster.instance().getUnicastEndpoint();
            if (gUESSEndpoint == null) {
                return;
            }
            if (!UDPService.this.canReceiveSolicited() && !UDPService.this.canReceiveUnsolicited()) {
                return;
            }
            PingRequest pingRequest = new PingRequest(UDPService.this.getSolicitedGUID().bytes(), 1, 0);
            pingRequest.addIPRequest();
            UDPService.this.send(pingRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
        }
    }
}

