/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ContentCache {
    private static final Log LOG;
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "responses.cache");
    private Map responses = new HashMap();
    private boolean dirty = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.auth.ContentCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    ContentCache() {
    }

    synchronized int getSize() {
        return this.responses.size();
    }

    synchronized boolean hasResponseFor(URN uRN) {
        return this.responses.containsKey(uRN);
    }

    synchronized void addResponse(URN uRN, ContentResponseData contentResponseData) {
        this.responses.put(uRN, contentResponseData);
        this.dirty = true;
    }

    synchronized ContentResponseData getResponse(URN uRN) {
        return (ContentResponseData)this.responses.get(uRN);
    }

    synchronized void initialize() {
        this.dirty = false;
        this.deserialize();
    }

    synchronized void writeToDisk() {
        if (this.dirty) {
            this.persistCache();
        }
        this.dirty = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deserialize() {
        long l = System.currentTimeMillis() - 604800000L;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                HashMap hashMap = (HashMap)objectInputStream.readObject();
                if (hashMap != null) {
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (!(k instanceof URN) || !(v instanceof ContentResponseData)) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)("Invalid k[" + k + "], v[" + v + "]"));
                            }
                            iterator.remove();
                            this.dirty = true;
                        }
                        if (((ContentResponseData)v).getCreationTime() >= l) continue;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Removing old response [" + v + "]"));
                        }
                        iterator.remove();
                        this.dirty = true;
                    }
                } else {
                    hashMap = new HashMap();
                }
                this.responses = hashMap;
            }
            catch (Throwable throwable) {
                this.dirty = true;
                LOG.error((Object)"Can't read responses", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            IOUtils.close(objectInputStream);
            if (this.responses != null) throw throwable;
            this.responses = new HashMap();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        IOUtils.close(objectInputStream);
        if (this.responses != null) return;
        this.responses = new HashMap();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void persistCache() {
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
                objectOutputStream.writeObject(this.responses);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IOUtils.close(objectOutputStream);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IOUtils.close(objectOutputStream);
    }
}

