/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.ContentCache;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.auth.SettingsBasedContentAuthority;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.settings.ContentSettings;
import com.limegroup.gnutella.util.ManagedThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentManager {
    private static final Log LOG;
    private final Map OBSERVERS = Collections.synchronizedMap(new HashMap());
    private final List RESPONDERS = new ArrayList();
    private final Set REQUESTED = Collections.synchronizedSet(new HashSet());
    private final Set TIMEOUTS = Collections.synchronizedSet(new HashSet());
    private final ContentCache CACHE = new ContentCache();
    private volatile ContentAuthority authority = null;
    private volatile boolean shutdown = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.auth.ContentManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void initialize() {
        this.CACHE.initialize();
        this.startProcessingThread();
    }

    public void shutdown() {
        this.shutdown = true;
        this.CACHE.writeToDisk();
    }

    public int getCacheSize() {
        return this.CACHE.getSize();
    }

    public void setContentAuthority(ContentAuthority contentAuthority) {
        this.authority = contentAuthority;
    }

    public boolean isVerified(URN uRN) {
        return !ContentSettings.isManagementActive() || this.CACHE.hasResponseFor(uRN) || this.TIMEOUTS.contains(uRN);
    }

    public void request(URN uRN, ContentResponseObserver contentResponseObserver, long l) {
        ContentResponseData contentResponseData = this.CACHE.getResponse(uRN);
        if (contentResponseData != null || !ContentSettings.isManagementActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Immediate response for URN: " + uRN));
            }
            contentResponseObserver.handleResponse(uRN, contentResponseData);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduling request for URN: " + uRN));
            }
            this.scheduleRequest(uRN, contentResponseObserver, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentResponseData request(URN uRN, long l) {
        Validator validator;
        Validator validator2 = validator = new Validator();
        synchronized (validator2) {
            this.request(uRN, validator, l);
            if (validator.hasResponse()) {
                return validator.getResponse();
            }
            try {
                validator.wait();
            }
            catch (InterruptedException interruptedException) {
                LOG.warn((Object)"Interrupted while waiting for response", (Throwable)interruptedException);
            }
            return validator.getResponse();
        }
    }

    public ContentResponseData getResponse(URN uRN) {
        return this.CACHE.getResponse(uRN);
    }

    protected void scheduleRequest(URN uRN, ContentResponseObserver contentResponseObserver, long l) {
        long l2 = System.currentTimeMillis();
        this.addResponder(new Responder(l2, l, contentResponseObserver, uRN));
        if (this.REQUESTED.add(uRN) && this.authority != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending request for URN: " + uRN + " to authority: " + this.authority));
            }
            this.authority.send(new ContentRequest(uRN));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Not sending request.  No authority or already requested.");
        }
    }

    public void handleContentResponse(ContentResponse contentResponse) {
        URN uRN = contentResponse.getURN();
        if (uRN != null && this.REQUESTED.remove(uRN)) {
            Collection collection;
            ContentResponseData contentResponseData = new ContentResponseData(contentResponse);
            this.CACHE.addResponse(uRN, contentResponseData);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding response (" + contentResponseData + ") for URN: " + uRN));
            }
            if ((collection = (Collection)this.OBSERVERS.remove(uRN)) != null) {
                this.removeResponders(collection);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Responder responder = (Responder)iterator.next();
                    responder.observer.handleResponse(responder.urn, contentResponseData);
                }
            }
        } else if (LOG.isWarnEnabled()) {
            if (uRN == null) {
                LOG.debug((Object)("No URN in response: " + contentResponse));
            } else {
                LOG.debug((Object)("Didn't request URN: " + uRN + ", msg: " + contentResponse));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResponders(Collection collection) {
        int n = collection.size();
        int n2 = 0;
        List list = this.RESPONDERS;
        synchronized (list) {
            int n3 = this.RESPONDERS.size() - 1;
            while (n3 >= 0) {
                Responder responder = (Responder)this.RESPONDERS.get(n3);
                if (collection.contains(responder)) {
                    this.RESPONDERS.remove(n3);
                    ++n2;
                }
                if (n2 == n) break;
                --n3;
            }
        }
        if (n2 != n) {
            LOG.warn((Object)"unable to remove all responders");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResponder(Responder responder) {
        Map map = this.OBSERVERS;
        synchronized (map) {
            HashSet<Responder> hashSet = (HashSet<Responder>)this.OBSERVERS.get(responder.urn);
            if (hashSet == null) {
                hashSet = new HashSet<Responder>();
            }
            hashSet.add(responder);
            this.OBSERVERS.put(responder.urn, hashSet);
            if (responder.dead != 0L) {
                this.addForTimeout(responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addForTimeout(Responder responder) {
        List list = this.RESPONDERS;
        synchronized (list) {
            if (this.RESPONDERS.isEmpty()) {
                this.RESPONDERS.add(responder);
            } else if (responder.dead <= ((Responder)this.RESPONDERS.get(this.RESPONDERS.size() - 1)).dead) {
                this.RESPONDERS.add(responder);
            } else {
                int n = Collections.binarySearch(this.RESPONDERS, responder);
                if (n < 0) {
                    n = (n + 1) * -1;
                }
                this.RESPONDERS.add(n, responder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout(long l) {
        Responder responder;
        ArrayList<Responder> arrayList = null;
        List list = this.RESPONDERS;
        synchronized (list) {
            responder = null;
            int n = this.RESPONDERS.size() - 1;
            while (n >= 0) {
                responder = (Responder)this.RESPONDERS.get(n);
                if (responder.dead > l) break;
                this.REQUESTED.remove(responder.urn);
                this.TIMEOUTS.add(responder.urn);
                if (arrayList == null) {
                    arrayList = new ArrayList<Responder>(2);
                }
                arrayList.add(responder);
                this.RESPONDERS.remove(n);
                responder = null;
                --n;
            }
        }
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                responder = (Responder)arrayList.get(n);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timing out responder: " + responder + " for URN: " + responder.urn));
                }
                try {
                    responder.observer.handleResponse(responder.urn, null);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable, "Content ContentResponseData Error");
                }
                ++n;
            }
        }
    }

    protected void startProcessingThread() {
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            public void run() {
                if (ContentManager.this.authority == null) {
                    ContentManager.this.setDefaultContentAuthority();
                }
                while (!ContentManager.this.shutdown) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (ContentManager.this.shutdown) continue;
                        ContentManager.this.timeout(System.currentTimeMillis());
                        continue;
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                        continue;
                    }
                    break;
                }
                return;
            }
        }, "ContentProcessor");
        managedThread.setDaemon(true);
        managedThread.start();
    }

    protected ContentAuthority getDefaultContentAuthority() {
        return new SettingsBasedContentAuthority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultContentAuthority() {
        ContentAuthority contentAuthority = this.getDefaultContentAuthority();
        if (contentAuthority.initialize() && contentAuthority != null) {
            HashSet hashSet = new HashSet();
            Object object = this.REQUESTED;
            synchronized (object) {
                hashSet.addAll(this.REQUESTED);
                this.setContentAuthority(contentAuthority);
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                URN uRN = (URN)object.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending delayed request for URN: " + uRN + " to: " + contentAuthority));
                }
                contentAuthority.send(new ContentRequest(uRN));
            }
        }
    }

    private static class Responder
    implements Comparable {
        private final long dead;
        private final ContentResponseObserver observer;
        private final URN urn;

        Responder(long l, long l2, ContentResponseObserver contentResponseObserver, URN uRN) {
            this.dead = l2 != 0L ? l + l2 : 0L;
            this.observer = contentResponseObserver;
            this.urn = uRN;
        }

        public int compareTo(Object object) {
            Responder responder = (Responder)object;
            return this.dead < responder.dead ? 1 : (this.dead > responder.dead ? -1 : 0);
        }
    }

    private static class Validator
    implements ContentResponseObserver {
        private boolean gotResponse = false;
        private ContentResponseData response = null;

        private Validator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(URN uRN, ContentResponseData contentResponseData) {
            Validator validator = this;
            synchronized (validator) {
                this.gotResponse = true;
                this.response = contentResponseData;
                this.notify();
            }
        }

        public boolean hasResponse() {
            return this.gotResponse;
        }

        public ContentResponseData getResponse() {
            return this.response;
        }
    }
}

