/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthority;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ContentSettings;
import com.limegroup.gnutella.util.IpPortImpl;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;

public class SettingsBasedContentAuthority
implements ContentAuthority {
    private ContentAuthority[] authorities;
    private Random RNG = this.newRandom();

    public boolean initialize() {
        String[] stringArray = ContentSettings.AUTHORITIES.getValue();
        ArrayList<IpPortContentAuthority> arrayList = new ArrayList<IpPortContentAuthority>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            try {
                arrayList.add(new IpPortContentAuthority(new IpPortImpl(stringArray[n])));
            }
            catch (UnknownHostException unknownHostException) {}
            ++n;
        }
        this.authorities = arrayList.toArray(new ContentAuthority[arrayList.size()]);
        return !arrayList.isEmpty();
    }

    public ContentAuthority[] getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(ContentAuthority[] contentAuthorityArray) {
        this.authorities = contentAuthorityArray;
    }

    public void send(Message message) {
        int n = this.RNG.nextInt(this.authorities.length);
        this.authorities[n].send(message);
    }

    protected Random newRandom() {
        return new Random();
    }
}

