/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostCache {
    private static final Log LOG;
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List udpHosts = new ArrayList(100);
    private final Set udpHostsSet = new HashSet();
    private final UDPPinger pinger;
    private final Set attemptedHosts;
    private boolean dirty = false;
    private boolean writeDirty = false;
    private static final Comparator FAILURE_COMPARATOR;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.bootstrap.UDPHostCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        FAILURE_COMPARATOR = new FailureComparator();
    }

    public UDPHostCache(UDPPinger uDPPinger) {
        this(600000L, uDPPinger);
    }

    public UDPHostCache(long l, UDPPinger uDPPinger) {
        this.attemptedHosts = new FixedSizeExpiringSet(100, l);
        this.pinger = uDPPinger;
    }

    public synchronized void write(Writer writer) throws IOException {
        Iterator iterator = this.udpHosts.iterator();
        while (iterator.hasNext()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            extendedEndpoint.write(writer);
        }
        this.writeDirty = false;
    }

    public synchronized boolean isWriteDirty() {
        return this.writeDirty;
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug((Object)"Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        Iterator iterator = this.attemptedHosts.iterator();
        while (iterator.hasNext()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            extendedEndpoint.decrementUDPHostCacheFailure();
            if (extendedEndpoint.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(extendedEndpoint);
            }
            this.dirty = true;
            this.writeDirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList arrayList = new ArrayList(Math.min(5, this.udpHosts.size()));
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.udpHosts.iterator();
        while (iterator.hasNext() && arrayList.size() < 5) {
            Object e = iterator.next();
            if (this.attemptedHosts.contains(e)) continue;
            if (NetworkUtils.isPrivateAddress(((ExtendedEndpoint)e).getAddress())) {
                linkedList.add(e);
                continue;
            }
            arrayList.add(e);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.remove((ExtendedEndpoint)iterator.next());
        }
        this.attemptedHosts.addAll(arrayList);
        return this.fetch(arrayList);
    }

    protected synchronized boolean fetch(Collection collection) {
        if (collection.isEmpty()) {
            LOG.debug((Object)"No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching endpoints from " + collection + " host caches"));
        }
        this.pinger.rank(collection, new HostExpirer(collection), new Cancellable(){

            public boolean isCancelled() {
                return RouterService.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return PingRequest.createUHCPing();
    }

    public synchronized boolean remove(ExtendedEndpoint extendedEndpoint) {
        boolean bl;
        boolean bl2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing endpoint: " + extendedEndpoint));
        }
        Assert.that((bl2 = this.udpHosts.remove(extendedEndpoint)) == (bl = this.udpHostsSet.remove(extendedEndpoint)), "Set " + bl2 + " but queue " + bl);
        if (bl2) {
            this.writeDirty = true;
        }
        return bl2;
    }

    public synchronized boolean add(ExtendedEndpoint extendedEndpoint) {
        Assert.that(extendedEndpoint.isUDPHostCache());
        if (this.udpHostsSet.contains(extendedEndpoint)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            Object e = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(e);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ejected: " + e));
            }
        }
        this.udpHosts.add(extendedEndpoint);
        this.udpHostsSet.add(extendedEndpoint);
        this.dirty = true;
        this.writeDirty = true;
        return true;
    }

    public synchronized void hostCachesAdded() {
        if (this.udpHostsSet.isEmpty()) {
            this.loadDefaults();
        }
    }

    protected void loadDefaults() {
    }

    private void createAndAdd(String string, int n) {
        try {
            ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(string, n).setUDPHostCache(true);
            this.add(extendedEndpoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private class HostExpirer
    implements MessageListener {
        private final Set hosts = new IpPortSet();
        private final Set allHosts;
        private byte[] guid;

        public HostExpirer(Collection collection) {
            this.hosts.addAll(collection);
            this.allHosts = new HashSet(collection);
            this.removeDuplicates(collection, this.hosts);
        }

        private void removeDuplicates(Collection collection, Collection collection2) {
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(collection2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing duplicate entry: " + extendedEndpoint));
                }
                UDPHostCache.this.remove(extendedEndpoint);
            }
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            if (replyHandler instanceof UDPReplyHandler) {
                if (this.hosts.remove(replyHandler) && LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recieved: " + message));
                }
                if (this.hosts.isEmpty()) {
                    RouterService.getMessageRouter().unregisterMessageListener(this.guid, this);
                }
            }
        }

        public void registered(byte[] byArray) {
            this.guid = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregistered(byte[] byArray) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                ExtendedEndpoint extendedEndpoint;
                Iterator iterator = this.hosts.iterator();
                while (iterator.hasNext()) {
                    extendedEndpoint = (ExtendedEndpoint)iterator.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                    if (extendedEndpoint.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(extendedEndpoint);
                }
                this.allHosts.removeAll(this.hosts);
                iterator = this.allHosts.iterator();
                while (iterator.hasNext()) {
                    extendedEndpoint = (ExtendedEndpoint)iterator.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Valid response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                }
            }
        }
    }

    private static class FailureComparator
    implements Comparator {
        private FailureComparator() {
        }

        public int compare(Object object, Object object2) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)object;
            ExtendedEndpoint extendedEndpoint2 = (ExtendedEndpoint)object2;
            return extendedEndpoint.getUDPHostCacheFailures() - extendedEndpoint2.getUDPHostCacheFailures();
        }
    }
}

