/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.SourceRanker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LegacyRanker
extends SourceRanker {
    private static final Log LOG;
    private final Set rfds = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.LegacyRanker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public synchronized boolean addToPool(RemoteFileDesc remoteFileDesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding host " + remoteFileDesc + " to be ranked"));
        }
        return this.rfds.add(remoteFileDesc);
    }

    public synchronized RemoteFileDesc getBest() {
        if (!this.hasMore()) {
            return null;
        }
        RemoteFileDesc remoteFileDesc = LegacyRanker.getBest(this.rfds.iterator());
        boolean bl = this.rfds.remove(remoteFileDesc);
        Assert.that(bl, "unable to remove RFD.");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("the best we came with is " + remoteFileDesc));
        }
        return remoteFileDesc;
    }

    static RemoteFileDesc getBest(Iterator iterator) {
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc2.isBusy(l)) continue;
            if (remoteFileDesc.isBusy(l)) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() != null && remoteFileDesc.getSHA1Urn() == null) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() == null != (remoteFileDesc.getSHA1Urn() == null)) continue;
            if (remoteFileDesc2.getQuality() > remoteFileDesc.getQuality()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getQuality() != remoteFileDesc.getQuality() || remoteFileDesc2.getSpeed() <= remoteFileDesc.getSpeed()) continue;
            remoteFileDesc = remoteFileDesc2;
        }
        return remoteFileDesc;
    }

    public boolean hasMore() {
        return !this.rfds.isEmpty();
    }

    protected Collection getShareableHosts() {
        return this.rfds;
    }

    protected Collection getPotentiallyBusyHosts() {
        return this.rfds;
    }

    public int getNumKnownHosts() {
        return this.rfds.size();
    }
}

