/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.util.Collection;
import java.util.Iterator;

public abstract class SourceRanker {
    protected MeshHandler meshHandler;

    public boolean addToPool(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!this.addToPool(remoteFileDesc)) continue;
            bl = true;
        }
        return bl;
    }

    public abstract boolean addToPool(RemoteFileDesc var1);

    public abstract boolean hasMore();

    public abstract RemoteFileDesc getBest();

    protected abstract Collection getShareableHosts();

    public abstract int getNumKnownHosts();

    public synchronized boolean hasNonBusy() {
        return this.getNumKnownHosts() > this.getNumBusyHosts();
    }

    public synchronized int getNumBusyHosts() {
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator iterator = this.getPotentiallyBusyHosts().iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!remoteFileDesc.isBusy(l)) continue;
            ++n;
        }
        return n;
    }

    public synchronized int calculateWaitTime() {
        if (!this.hasMore()) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        long l = System.currentTimeMillis();
        Iterator iterator = this.getPotentiallyBusyHosts().iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!remoteFileDesc.isBusy(l)) continue;
            n = Math.min(n, remoteFileDesc.getWaitTime(l));
        }
        return n * 1000;
    }

    protected abstract Collection getPotentiallyBusyHosts();

    public synchronized void stop() {
        this.clearState();
        this.meshHandler = null;
    }

    protected void clearState() {
    }

    public static SourceRanker getAppropriateRanker() {
        if (RouterService.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            return new PingRanker();
        }
        return new LegacyRanker();
    }

    public static SourceRanker getAppropriateRanker(SourceRanker sourceRanker) {
        SourceRanker sourceRanker2;
        if (sourceRanker == null) {
            return SourceRanker.getAppropriateRanker();
        }
        if (RouterService.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            if (sourceRanker instanceof PingRanker) {
                return sourceRanker;
            }
            sourceRanker2 = new PingRanker();
        } else {
            if (sourceRanker instanceof LegacyRanker) {
                return sourceRanker;
            }
            sourceRanker2 = new LegacyRanker();
        }
        sourceRanker2.setMeshHandler(sourceRanker.getMeshHandler());
        sourceRanker2.addToPool(sourceRanker.getShareableHosts());
        sourceRanker.stop();
        return sourceRanker2;
    }

    public synchronized void setMeshHandler(MeshHandler meshHandler) {
        this.meshHandler = meshHandler;
    }

    public synchronized MeshHandler getMeshHandler() {
        return this.meshHandler;
    }
}

