/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrottleReader
implements InterestReadChannel,
ChannelReader,
ThrottleListener {
    private static final Log LOG;
    private volatile InterestReadChannel channel;
    private final Throttle throttle;
    private int available;
    private Object attachment;
    private volatile boolean lastInterestState;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.ThrottleReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public ThrottleReader(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleReader(Throttle throttle, InterestReadChannel interestReadChannel) {
        this.throttle = throttle;
        this.channel = interestReadChannel;
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    public void setReadChannel(InterestReadChannel interestReadChannel) {
        this.channel = interestReadChannel;
        this.throttle.interest(this);
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void interest(boolean bl) {
        this.lastInterestState = bl;
        if (this.channel != null) {
            if (bl) {
                this.throttle.interest(this);
            } else {
                this.channel.interest(false);
            }
        }
    }

    public boolean bandwidthAvailable() {
        if (this.channel.isOpen() && this.lastInterestState) {
            this.channel.interest(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        InterestReadChannel interestReadChannel = this.channel;
        if (interestReadChannel == null) {
            throw new IllegalStateException("reading with no chain!");
        }
        if (this.available == 0) {
            return 0;
        }
        int n = byteBuffer.limit();
        if (byteBuffer.remaining() > this.available) {
            byteBuffer.limit(byteBuffer.position() + this.available);
        }
        int n2 = -1;
        try {
            n2 = this.channel.read(byteBuffer);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            byteBuffer.limit(n);
            throw throwable;
        }
        {
            Object var5_7 = null;
            byteBuffer.limit(n);
        }
        this.available -= n2;
        return n2;
    }

    public void close() throws IOException {
        InterestReadChannel interestReadChannel = this.channel;
        if (interestReadChannel != null) {
            interestReadChannel.close();
        }
    }

    public boolean isOpen() {
        InterestReadChannel interestReadChannel = this.channel;
        return interestReadChannel != null ? interestReadChannel.isOpen() : false;
    }

    public void requestBandwidth() {
        this.available = this.throttle.request();
        this.channel.interest(false);
    }

    public void releaseBandwidth() {
        this.throttle.release(this.available);
        this.available = 0;
        if (this.lastInterestState) {
            this.throttle.interest(this);
        }
    }
}

