/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.util.DataUtils;

public final class UpdateRequest
extends VendorMessage {
    public static final int VERSION = 1;
    static final String COMPRESSED_UPDATE_KEY = "C";
    static final String UNCOMPRESSED_UPDATE_KEY = "U";
    private GGEP _ggep;
    private boolean parsed;

    UpdateRequest(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 26, n, byArray2);
    }

    public UpdateRequest() {
        super(F_LIME_VENDOR_ID, 26, 1, DataUtils.EMPTY_BYTE_ARRAY);
    }

    public int getVersion() {
        return super.getVersion();
    }

    public String toString() {
        return "{UpdateRequest:" + super.toString() + "}";
    }

    public boolean hasGGEP() {
        if (this._ggep == null && !this.parsed) {
            this._ggep = this.parseGGEP();
            this.parsed = true;
        }
        return this._ggep != null;
    }

    private GGEP parseGGEP() {
        byte[] byArray = this.getPayload();
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return new GGEP(byArray, 0, null);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            return null;
        }
    }

    public boolean requestsCompressed() {
        if (!this.hasGGEP()) {
            return false;
        }
        return this._ggep.hasKey(COMPRESSED_UPDATE_KEY);
    }
}

