/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class VendorMessage
extends Message {
    public static final int F_MESSAGES_SUPPORTED = 0;
    public static final int F_HOPS_FLOW = 4;
    public static final int F_TCP_CONNECT_BACK = 7;
    public static final int F_UDP_CONNECT_BACK = 7;
    public static final int F_UDP_CONNECT_BACK_REDIR = 8;
    public static final int F_CAPABILITIES = 10;
    public static final int F_LIME_ACK = 11;
    public static final int F_REPLY_NUMBER = 12;
    public static final int F_PUSH_PROXY_REQ = 21;
    public static final int F_PUSH_PROXY_ACK = 22;
    public static final int F_GIVE_STATS = 14;
    public static final int F_STATISTICS = 15;
    public static final int F_CRAWLER_PING = 5;
    public static final int F_CRAWLER_PONG = 6;
    public static final int F_SIMPP_REQ = 16;
    public static final int F_SIMPP = 17;
    public static final int F_UDP_HEAD_PING = 23;
    public static final int F_UDP_HEAD_PONG = 24;
    public static final int F_HEADER_UPDATE = 25;
    public static final int F_UPDATE_REQ = 26;
    public static final int F_UPDATE_RESP = 27;
    public static final int F_CONTENT_REQ = 28;
    public static final int F_CONTENT_RESP = 29;
    public static final byte[] F_LIME_VENDOR_ID = new byte[]{76, 73, 77, 69};
    public static final byte[] F_BEAR_VENDOR_ID = new byte[]{66, 69, 65, 82};
    public static final byte[] F_GTKG_VENDOR_ID = new byte[]{71, 84, 75, 71};
    public static final byte[] F_NULL_VENDOR_ID = new byte[4];
    static final int LENGTH_MINUS_PAYLOAD = 8;
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected VendorMessage(byte[] byArray, int n, int n2, byte[] byArray2) {
        this(byArray, n, n2, byArray2, -1);
    }

    protected VendorMessage(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        super((byte)49, (byte)1, 8 + byArray2.length, n3);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + byArray.length);
        }
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + n);
        }
        if ((n2 & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + n2);
        }
        this._vendorID = byArray;
        this._selector = n;
        this._version = n2;
        this._payload = byArray2;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected VendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3) throws BadPacketException {
        this(byArray, by, by2, byArray2, n, n2, byArray3, -1);
    }

    protected VendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws BadPacketException {
        super(byArray, (byte)49, by, by2, 8 + byArray3.length, n3);
        if (byArray2.length != 4) {
            ReceivedErrorStat.VENDOR_INVALID_ID.incrementStat();
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((n & 0xFFFF0000) != 0) {
            ReceivedErrorStat.VENDOR_INVALID_SELECTOR.incrementStat();
            throw new BadPacketException("Selector Invalid!");
        }
        if ((n2 & 0xFFFF0000) != 0) {
            ReceivedErrorStat.VENDOR_INVALID_VERSION.incrementStat();
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = byArray2;
        this._selector = n;
        this._version = n2;
        this._payload = byArray3;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = 0;
        n3 += 17 * n;
        n3 += 17 * n2;
        int n4 = 0;
        while (n4 < byArray.length) {
            n3 += 17 * byArray[n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < byArray2.length) {
            n3 += 17 * byArray2[n4];
            ++n4;
        }
        return n3;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    protected int getVersion() {
        return this._version;
    }

    public boolean equals(Object object) {
        if (object instanceof VendorMessage) {
            VendorMessage vendorMessage = (VendorMessage)object;
            return this._selector == vendorMessage._selector && Arrays.equals(this._vendorID, vendorMessage._vendorID) && Arrays.equals(this._payload, vendorMessage._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, outputStream);
        ByteOrder.short2leb((short)this._version, outputStream);
        outputStream.write(this.getPayload());
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

