/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.security.SignatureVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimppDataVerifier {
    private static final Log LOG;
    private static final byte SEP = 124;
    public final String DSA_ALGORITHM = "DSA";
    private byte[] simppPayload;
    private byte[] verifiedData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.simpp.SimppDataVerifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public SimppDataVerifier(byte[] byArray) {
        this.simppPayload = byArray;
    }

    public boolean verifySource() {
        int n = SimppDataVerifier.findSeperator(this.simppPayload);
        if (n < 0) {
            return false;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.simppPayload, 0, byArray, 0, n);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        byte[] byArray2 = Base32.decode(string);
        byte[] byArray3 = new byte[this.simppPayload.length - 1 - n];
        System.arraycopy(this.simppPayload, n + 1, byArray3, 0, this.simppPayload.length - 1 - n);
        PublicKey publicKey = this.getPublicKey();
        if (publicKey == null) {
            return false;
        }
        String string2 = "DSA";
        SignatureVerifier signatureVerifier = new SignatureVerifier(byArray3, byArray2, publicKey, string2);
        boolean bl = signatureVerifier.verifySignature();
        if (bl) {
            this.verifiedData = byArray3;
        }
        return bl;
    }

    public byte[] getVerifiedData() {
        return this.verifiedData;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicKey getPublicKey() {
        PublicKey publicKey;
        byte[] byArray;
        File file = new File(CommonUtils.getUserSettingsDir(), "pub1.key");
        String string = null;
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                byArray = new byte[(int)randomAccessFile.length()];
                randomAccessFile.readFully(byArray);
                string = new String(byArray, "UTF-8");
            }
            catch (IOException iOException) {
                LOG.error((Object)"IOX reading file", (Throwable)iOException);
                Object var5_6 = null;
                try {
                    if (randomAccessFile == null) return null;
                    randomAccessFile.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {}
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
            throw throwable;
        }
        {
            publicKey = null;
        }
        try {}
        catch (IOException iOException) {}
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        byArray = Base32.decode(string);
        publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"no algorithm", (Throwable)noSuchAlgorithmException);
            return publicKey;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOG.error((Object)"invalid key", (Throwable)invalidKeySpecException);
        }
        return publicKey;
    }

    static int findSeperator(byte[] byArray) {
        boolean bl = false;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 124) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }
}

