/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class SimppManager {
    private static final Log LOG;
    private static SimppManager INSTANCE;
    private int _latestVersion;
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION;
    private byte[] _simppBytes;
    private String _propsStream;
    private final ProcessingQueue _processingQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.simpp.SimppManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_VERSION = 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimppManager() {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        this._processingQueue = new ProcessingQueue("Simpp Handling Queue");
        try {
            try {
                SimppParser simppParser;
                byte[] byArray;
                block21: {
                    block18: {
                        SimppDataVerifier simppDataVerifier;
                        block20: {
                            File file = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
                            randomAccessFile = new RandomAccessFile(file, "r");
                            byArray = new byte[(int)randomAccessFile.length()];
                            randomAccessFile.readFully(byArray);
                            simppDataVerifier = new SimppDataVerifier(byArray);
                            boolean bl2 = false;
                            this._latestVersion = 0;
                            bl2 = simppDataVerifier.verifySource();
                            if (bl2) break block20;
                            LOG.debug((Object)"Unable to verify simpp message.");
                            bl = true;
                            break block18;
                        }
                        simppParser = null;
                        try {
                            simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
                        }
                        catch (SAXException sAXException) {
                            LOG.error((Object)"Unable to parse simpp data on disk", (Throwable)sAXException);
                            bl = true;
                            break block18;
                        }
                        catch (IOException iOException) {
                            LOG.error((Object)"IOX parsing simpp on disk", (Throwable)iOException);
                            bl = true;
                            break block18;
                        }
                        if (simppParser.getVersion() > MIN_VERSION) break block21;
                        LOG.error((Object)"Version below min on disk, aborting simpp.");
                        bl = true;
                    }
                    Object var9_8 = null;
                    if (bl) {
                        this._latestVersion = MIN_VERSION;
                        this._propsStream = "";
                        this._simppBytes = "".getBytes();
                    }
                    if (randomAccessFile == null) return;
                    try {
                        randomAccessFile.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                this._latestVersion = simppParser.getVersion();
                this._propsStream = simppParser.getPropsData();
                this._simppBytes = byArray;
            }
            catch (IOException iOException) {
                LOG.error((Object)"IOX reading simpp xml on disk", (Throwable)iOException);
                bl = true;
            }
            Object var9_10 = null;
            if (bl) {
                this._latestVersion = MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) {
                this._latestVersion = MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (randomAccessFile == null) throw throwable;
            try {}
            catch (IOException iOException) {}
            randomAccessFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        randomAccessFile.close();
    }

    public static synchronized SimppManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppManager();
        }
        return INSTANCE;
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final byte[] byArray) {
        if (byArray == null) {
            return;
        }
        final int n = this._latestVersion;
        Runnable runnable = new Runnable(){

            public void run() {
                SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
                if (!simppDataVerifier.verifySource()) {
                    return;
                }
                SimppParser simppParser = null;
                try {
                    simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
                }
                catch (SAXException sAXException) {
                    LOG.error((Object)"SAX error reading network simpp", (Throwable)sAXException);
                    return;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOX parsing network simpp", (Throwable)iOException);
                    return;
                }
                int n3 = simppParser.getVersion();
                if (n3 <= n) {
                    LOG.error((Object)"Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = n3;
                SimppManager.this._simppBytes = byArray;
                SimppManager.this._propsStream = simppParser.getPropsData();
                String string = simppParser.getPropsData();
                SimppSettingsManager.instance().updateSimppSettings(string);
                int n2 = 0;
                while (n2 < 5) {
                    if (SimppManager.this.save()) break;
                    ++n2;
                }
                CapabilitiesVM.reconstructInstance();
                RouterService.getConnectionManager().sendUpdatedCapabilities();
            }
        };
        this._processingQueue.add(runnable);
    }

    /*
     * Exception decompiling
     */
    public boolean save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 89->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

