/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class HashTreeNodeManager {
    private static final HashTreeNodeManager INSTANCE = new HashTreeNodeManager();
    private static final int MAX_NODES = 500;
    private FixedsizeForgetfulHashMap MAP = new FixedsizeForgetfulHashMap(250);
    private int _currentNodes = 0;

    public static HashTreeNodeManager instance() {
        return INSTANCE;
    }

    private HashTreeNodeManager() {
    }

    List getAllNodes(HashTree hashTree) {
        int n = hashTree.getDepth();
        if (hashTree.getDepth() == 0) {
            ArrayList<List> arrayList = new ArrayList<List>(1);
            arrayList.add(hashTree.getNodes());
            return arrayList;
        }
        if (n < 2 || n >= 7) {
            return HashTree.createAllParentNodes(hashTree.getNodes());
        }
        return this.getAllNodesImpl(hashTree);
    }

    void register(HashTree hashTree, List list) {
        int n = hashTree.getDepth();
        if (n > 2 && n < 7 && !this.MAP.containsKey(hashTree)) {
            this.insertEntry(hashTree, list);
        }
    }

    private synchronized List getAllNodesImpl(HashTree hashTree) {
        List list = (List)this.MAP.get(hashTree);
        if (list != null) {
            this.MAP.put(hashTree, list);
            return list;
        }
        list = HashTree.createAllParentNodes(hashTree.getNodes());
        this.insertEntry(hashTree, list);
        return list;
    }

    private synchronized void insertEntry(HashTree hashTree, List list) {
        int n = HashTreeNodeManager.calculateSize(list);
        while (this._currentNodes + n > 500) {
            if (this.MAP.isEmpty()) {
                throw new IllegalStateException("current: " + this._currentNodes + ", size: " + n);
            }
            this.purgeLRU();
        }
        this._currentNodes += n;
        this.MAP.put(hashTree, list);
    }

    private synchronized void purgeLRU() {
        List list = (List)this.MAP.removeLRUEntry();
        this._currentNodes -= HashTreeNodeManager.calculateSize(list);
    }

    private static int calculateSize(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            n += ((List)iterator.next()).size();
        }
        return n;
    }
}

