/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import java.nio.ByteBuffer;

public class DataMessage
extends UDPConnectionMessage {
    public static final int MAX_DATA = 512;
    private final ByteBuffer chunk;

    public DataMessage(byte by, long l, ByteBuffer byteBuffer) {
        super(by, (byte)3, l, byteBuffer.array(), byteBuffer.remaining());
        this.chunk = byteBuffer;
    }

    public DataMessage(byte by, long l, byte[] byArray, int n) {
        super(by, (byte)3, l, byArray, n);
        this.chunk = null;
    }

    ByteBuffer getChunk() {
        return this.chunk;
    }

    public DataMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2);
        this.chunk = null;
    }

    public ByteBuffer getData1Chunk() {
        return this._data1;
    }

    public ByteBuffer getData2Chunk() {
        return this._data2;
    }

    public byte getDataAt(int n) {
        if (n < 12) {
            return this._data1.get(n + this._data1.position());
        }
        return this._data2.get(n - 12 + this._data2.position());
    }

    public String toString() {
        return "DataMessage DestID:" + this.getConnectionID() + " len:" + this.getDataLength() + " seq:" + this.getSequenceNumber();
    }
}

